/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item;

import alexthw.eidolon_repraised.common.item.Tiers;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

public class ReversalPickItem
extends PickaxeItem {
    String loreTag = null;

    public ReversalPickItem(Item.Properties builderIn) {
        super((Tier)Tiers.MagicToolTier.INSTANCE, builderIn.attributes(PickaxeItem.createAttributes((Tier)Tiers.MagicToolTier.INSTANCE, (float)1.0f, (float)-2.8f)));
        NeoForge.EVENT_BUS.addListener(ReversalPickItem::onStartBreak);
    }

    public Item setLore(String tag) {
        this.loreTag = tag;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (this.loreTag != null) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_PURPLE) + String.valueOf(ChatFormatting.ITALIC) + I18n.get((String)this.loreTag, (Object[])new Object[0]))));
        }
    }

    @SubscribeEvent
    public static void onStartBreak(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().getMainHandItem().getItem() instanceof ReversalPickItem && event.getPosition().isPresent()) {
            float hardness = event.getState().getDestroySpeed((BlockGetter)event.getEntity().level(), (BlockPos)event.getPosition().get());
            float adjHardness = 1.0f / (hardness / 2.0f);
            float newSpeed = Mth.sqrt((float)(event.getOriginalSpeed() * 0.25f)) * Mth.sqrt((float)(hardness / adjHardness));
            event.setNewSpeed(newSpeed);
        }
    }
}

