/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public class GenericParticleData
implements ParticleOptions {
    float r1 = 1.0f;
    float g1 = 1.0f;
    float b1 = 1.0f;
    float a1 = 1.0f;
    float r2 = 1.0f;
    float g2 = 1.0f;
    float b2 = 1.0f;
    float a2 = 0.0f;
    float scale1 = 1.0f;
    float scale2 = 0.0f;
    int lifetime = 20;
    float spin = 0.0f;
    boolean gravity = false;
    final ParticleType<?> type;

    public static MapCodec<GenericParticleData> codecFor(ParticleType<?> type) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("r1").forGetter(d -> Float.valueOf(d.r1)), (App)Codec.FLOAT.fieldOf("g1").forGetter(d -> Float.valueOf(d.g1)), (App)Codec.FLOAT.fieldOf("b1").forGetter(d -> Float.valueOf(d.b1)), (App)Codec.FLOAT.fieldOf("a1").forGetter(d -> Float.valueOf(d.a1)), (App)Codec.FLOAT.fieldOf("r2").forGetter(d -> Float.valueOf(d.r2)), (App)Codec.FLOAT.fieldOf("g2").forGetter(d -> Float.valueOf(d.g2)), (App)Codec.FLOAT.fieldOf("b2").forGetter(d -> Float.valueOf(d.b2)), (App)Codec.FLOAT.fieldOf("a2").forGetter(d -> Float.valueOf(d.a2)), (App)Codec.FLOAT.fieldOf("scale1").forGetter(d -> Float.valueOf(d.scale1)), (App)Codec.FLOAT.fieldOf("scale2").forGetter(d -> Float.valueOf(d.scale2)), (App)Codec.INT.fieldOf("lifetime").forGetter(d -> d.lifetime), (App)Codec.FLOAT.fieldOf("spin").forGetter(d -> Float.valueOf(d.spin)), (App)Codec.BOOL.fieldOf("gravity").forGetter(d -> d.gravity)).apply((Applicative)instance, (r1, g1, b1, a1, r2, g2, b2, a2, scale1, scale2, lifetime, spin, gravity) -> {
            GenericParticleData data = new GenericParticleData(type);
            data.r1 = r1.floatValue();
            data.g1 = g1.floatValue();
            data.b1 = b1.floatValue();
            data.a1 = a1.floatValue();
            data.r2 = r2.floatValue();
            data.g2 = g2.floatValue();
            data.b2 = b2.floatValue();
            data.a2 = a2.floatValue();
            data.scale1 = scale1.floatValue();
            data.scale2 = scale2.floatValue();
            data.lifetime = lifetime;
            data.spin = spin.floatValue();
            data.gravity = gravity;
            return data;
        }));
    }

    public GenericParticleData(ParticleType<?> type) {
        this.type = type;
    }

    @NotNull
    public static StreamCodec<RegistryFriendlyByteBuf, GenericParticleData> streamCodecFor(ParticleType<? extends GenericParticleData> featherParticleType) {
        return StreamCodec.of(GenericParticleData::writeToNetwork, buf -> {
            float r1 = buf.readFloat();
            float g1 = buf.readFloat();
            float b1 = buf.readFloat();
            float a1 = buf.readFloat();
            float r2 = buf.readFloat();
            float g2 = buf.readFloat();
            float b2 = buf.readFloat();
            float a2 = buf.readFloat();
            float scale1 = buf.readFloat();
            float scale2 = buf.readFloat();
            int lifetime = buf.readInt();
            float spin = buf.readFloat();
            boolean gravity = buf.readBoolean();
            GenericParticleData data = new GenericParticleData(featherParticleType);
            data.r1 = r1;
            data.g1 = g1;
            data.b1 = b1;
            data.a1 = a1;
            data.r2 = r2;
            data.g2 = g2;
            data.b2 = b2;
            data.a2 = a2;
            data.scale1 = scale1;
            data.scale2 = scale2;
            data.lifetime = lifetime;
            data.spin = spin;
            data.gravity = gravity;
            return data;
        });
    }

    @NotNull
    public ParticleType<?> getType() {
        return this.type;
    }

    public static void writeToNetwork(FriendlyByteBuf buffer, GenericParticleData data) {
        buffer.writeFloat(data.r1).writeFloat(data.g1).writeFloat(data.b1).writeFloat(data.a1);
        buffer.writeFloat(data.r2).writeFloat(data.g2).writeFloat(data.b2).writeFloat(data.a2);
        buffer.writeFloat(data.scale1).writeFloat(data.scale2);
        buffer.writeInt(data.lifetime);
        buffer.writeFloat(data.spin);
        buffer.writeBoolean(data.gravity);
    }
}

