/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.api.ritual;

import alexthw.eidolon_repraised.api.ritual.IRequirement;
import alexthw.eidolon_repraised.api.ritual.RequirementInfo;
import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.network.RitualConsumePacket;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class HealthRequirement
implements IRequirement {
    final float health;

    public float getHealth() {
        return this.health;
    }

    public HealthRequirement(float health) {
        this.health = health;
    }

    @Override
    public RequirementInfo isMet(Ritual ritual, Level world, BlockPos pos) {
        if (this.health <= 0.0f) {
            return RequirementInfo.TRUE;
        }
        List entities = world.getEntitiesOfClass(Mob.class, Ritual.getDefaultBounds(pos), entity -> !entity.isInvertedHealAndHarm());
        List players = world.getEntitiesOfClass(Player.class, Ritual.getDefaultBounds(pos));
        ArrayList targets = new ArrayList();
        targets.addAll(entities);
        targets.addAll(players);
        float acc = 0.0f;
        for (LivingEntity target : targets) {
            if (!((acc += target.getHealth()) >= this.health)) continue;
            return RequirementInfo.TRUE;
        }
        return RequirementInfo.FALSE;
    }

    @Override
    public void whenMet(Ritual ritual, Level world, BlockPos pos, RequirementInfo info) {
        if (this.health <= 0.0f) {
            return;
        }
        List entities = world.getEntitiesOfClass(Mob.class, Ritual.getDefaultBounds(pos), entity -> !entity.isInvertedHealAndHarm());
        List players = world.getEntitiesOfClass(Player.class, Ritual.getDefaultBounds(pos));
        ArrayList targets = new ArrayList();
        targets.addAll(entities);
        targets.addAll(players);
        float acc = 0.0f;
        for (LivingEntity target : targets) {
            float targetHealth = target.getHealth();
            target.hurt(Registry.RITUAL_DAMAGE.source((LevelAccessor)world), Math.min(this.health - acc, targetHealth));
            acc += targetHealth;
            if (!world.isClientSide) {
                Networking.sendToNearbyClient(world, pos, (CustomPacketPayload)new RitualConsumePacket(target.blockPosition(), pos, ritual.getRed(), ritual.getGreen(), ritual.getBlue()));
            }
            if (!(acc >= this.health)) continue;
            return;
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }
}

