/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.util;

import alexthw.eidolon_repraised.client.ClientRegistry;
import alexthw.eidolon_repraised.util.ClientInfo;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RenderUtil {
    public static final RenderStateShard.TransparencyStateShard ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderStateShard.TransparencyStateShard NORMAL_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderType GLOWING_SPRITE = RenderType.create((String)"eidolon_repraised:glowing_sprite", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false)).setLightmapState(new RenderStateShard.LightmapStateShard(false)).setTransparencyState(ADDITIVE_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.BLOCK_ATLAS, false, false)).setShaderState(new RenderStateShard.ShaderStateShard(ClientRegistry::getGlowingSpriteShader)).createCompositeState(false));
    public static final RenderType GLOWING = RenderType.create((String)"eidolon_repraised:glowing", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false)).setLightmapState(new RenderStateShard.LightmapStateShard(false)).setTransparencyState(ADDITIVE_TRANSPARENCY).setShaderState(new RenderStateShard.ShaderStateShard(ClientRegistry::getGlowingShader)).createCompositeState(false));
    public static final RenderType DELAYED_PARTICLE = RenderType.create((String)"eidolon_repraised:delayed_particle", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false)).setTransparencyState(NORMAL_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_PARTICLES, false, false)).setShaderState(new RenderStateShard.ShaderStateShard(ClientRegistry::getSpriteParticleShader)).createCompositeState(false));
    public static final RenderType GLOWING_PARTICLE = RenderType.create((String)"eidolon_repraised:glowing_particle", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false)).setLightmapState(new RenderStateShard.LightmapStateShard(false)).setTransparencyState(ADDITIVE_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_PARTICLES, false, false)).setShaderState(new RenderStateShard.ShaderStateShard(ClientRegistry::getGlowingParticleShader)).createCompositeState(false));
    public static final RenderType GLOWING_BLOCK_PARTICLE = RenderType.create((String)"eidolon_repraised:glowing_particle", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false)).setLightmapState(new RenderStateShard.LightmapStateShard(false)).setTransparencyState(ADDITIVE_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.BLOCK_ATLAS, false, false)).setShaderState(new RenderStateShard.ShaderStateShard(ClientRegistry::getGlowingParticleShader)).createCompositeState(false));
    public static final RenderType VAPOR_TRANSLUCENT = RenderType.create((String)"eidolon_repraised:vapor_translucent", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(new RenderStateShard.LightmapStateShard(false)).setTransparencyState(NORMAL_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.BLOCK_ATLAS, false, false)).setShaderState(new RenderStateShard.ShaderStateShard(ClientRegistry::getVaporShader)).createCompositeState(false));
    private static final float ROOT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public static void litQuad(PoseStack mStack, MultiBufferSource buffer, double x, double y, double w, double h, float r, float g, float b, float a, TextureAtlasSprite sprite) {
        VertexConsumer builder = buffer.getBuffer(GLOWING_SPRITE);
        float f7 = sprite.getU0();
        float f8 = sprite.getU1();
        float f5 = sprite.getV0();
        float f6 = sprite.getV1();
        Matrix4f mat = mStack.last().pose();
        builder.addVertex(mat, (float)x, (float)y + (float)h, 0.0f).setUv(f7, f6).setColor(r, g, b, a);
        builder.addVertex(mat, (float)x + (float)w, (float)y + (float)h, 0.0f).setUv(f8, f6).setColor(r, g, b, a);
        builder.addVertex(mat, (float)x + (float)w, (float)y, 0.0f).setUv(f8, f5).setColor(r, g, b, a);
        builder.addVertex(mat, (float)x, (float)y, 0.0f).setUv(f7, f5).setColor(r, g, b, a);
    }

    public static void litQuad(PoseStack mStack, MultiBufferSource buffer, double x, double y, double w, double h, float r, float g, float b, TextureAtlasSprite sprite) {
        RenderUtil.litQuad(mStack, buffer, x, y, w, h, r, g, b, 1.0f, sprite);
    }

    public static void litQuad(PoseStack mStack, MultiBufferSource buffer, double x, double y, double w, double h, float r, float g, float b, float u, float v, float uw, float vh) {
        VertexConsumer builder = buffer.getBuffer(GLOWING_SPRITE);
        Matrix4f mat = mStack.last().pose();
        builder.addVertex(mat, (float)x, (float)y + (float)h, 0.0f).setUv(u, v + vh).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, (float)x + (float)w, (float)y + (float)h, 0.0f).setUv(u + uw, v + vh).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, (float)x + (float)w, (float)y, 0.0f).setUv(u + uw, v).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, (float)x, (float)y, 0.0f).setUv(u, v).setColor(r, g, b, 1.0f);
    }

    public static void litBillboard(PoseStack mStack, MultiBufferSource buffer, double x, double y, double z, float r, float g, float b, TextureAtlasSprite sprite) {
        VertexConsumer builder = buffer.getBuffer(GLOWING_SPRITE);
        Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 vector3d = renderInfo.getPosition();
        float partialTicks = Minecraft.getInstance().getFrameTimeNs();
        float f = (float)x;
        float f1 = (float)y;
        float f2 = (float)z;
        Quaternionf quaternion = renderInfo.rotation();
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-0.5f, -0.5f, 0.0f), new Vector3f(-0.5f, 0.5f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.5f, -0.5f, 0.0f)};
        float f4 = 1.0f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = sprite.getU0();
        float f8 = sprite.getU1();
        float f5 = sprite.getV0();
        float f6 = sprite.getV1();
        Matrix4f mat = mStack.last().pose();
        builder.addVertex(mat, avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setUv(f8, f6).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setUv(f8, f5).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setUv(f7, f5).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setUv(f7, f6).setColor(r, g, b, 1.0f);
    }

    public static void dragon(PoseStack mStack, MultiBufferSource buf, double x, double y, double z, float radius, float r, float g, float b) {
        float f5 = 0.5f;
        float f7 = 0.0f;
        Random random = new Random(432L);
        VertexConsumer builder = buf.getBuffer(GLOWING);
        mStack.pushPose();
        mStack.translate(x, y, z);
        float rotation = ClientInfo.getClientPartialTicks() / 200.0f;
        int i = 0;
        while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
            mStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
            mStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
            mStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f));
            mStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
            mStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
            mStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f + rotation * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            f3 *= 0.05f * radius;
            f4 *= 0.05f * radius;
            Matrix4f mat = mStack.last().pose();
            float alpha = 1.0f - f7;
            builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha);
            builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha);
            builder.addVertex(mat, -ROOT_3 * f4, f3, -0.5f * f4).setColor(r, g, b, 0.0f);
            builder.addVertex(mat, ROOT_3 * f4, f3, -0.5f * f4).setColor(r, g, b, 0.0f);
            builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha);
            builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha);
            builder.addVertex(mat, ROOT_3 * f4, f3, -0.5f * f4).setColor(r, g, b, 0.0f);
            builder.addVertex(mat, 0.0f, f3, f4).setColor(r, g, b, 0.0f);
            builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha);
            builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha);
            builder.addVertex(mat, 0.0f, f3, f4).setColor(r, g, b, 0.0f);
            builder.addVertex(mat, -ROOT_3 * f4, f3, -0.5f * f4).setColor(r, g, b, 0.0f);
            ++i;
        }
        mStack.popPose();
    }

    public static void vaporCube(PoseStack mStack, VertexConsumer builder, TextureAtlasSprite sprite, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a, int light, boolean nx, boolean px, boolean ny, boolean py, boolean nz, boolean pz) {
        Matrix4f mat = mStack.last().pose();
        if (py) {
            builder.addVertex(mat, x1, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16.0f), sprite.getV(x1 * 16.0f)).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(mat, x1, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16.0f), sprite.getV(x1 * 16.0f)).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(mat, x2, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16.0f), sprite.getV(x2 * 16.0f)).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(mat, x2, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16.0f), sprite.getV(x2 * 16.0f)).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        }
        if (ny) {
            builder.addVertex(mat, x1, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16.0f), sprite.getV(x1 * 16.0f)).setLight(light).setNormal(0.0f, -1.0f, 0.0f);
            builder.addVertex(mat, x1, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16.0f), sprite.getV(x1 * 16.0f)).setLight(light).setNormal(0.0f, -1.0f, 0.0f);
            builder.addVertex(mat, x2, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16.0f), sprite.getV(x2 * 16.0f)).setLight(light).setNormal(0.0f, -1.0f, 0.0f);
            builder.addVertex(mat, x2, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16.0f), sprite.getV(x2 * 16.0f)).setLight(light).setNormal(0.0f, -1.0f, 0.0f);
        }
        if (nz) {
            builder.addVertex(mat, x2, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(x1 * 16.0f), sprite.getV(y1 * 16.0f)).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
            builder.addVertex(mat, x1, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(x2 * 16.0f), sprite.getV(y1 * 16.0f)).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
            builder.addVertex(mat, x1, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(x2 * 16.0f), sprite.getV(y2 * 16.0f)).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
            builder.addVertex(mat, x2, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(x1 * 16.0f), sprite.getV(y2 * 16.0f)).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        }
        if (pz) {
            builder.addVertex(mat, x1, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(x1 * 16.0f), sprite.getV(y1 * 16.0f)).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
            builder.addVertex(mat, x2, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(x2 * 16.0f), sprite.getV(y1 * 16.0f)).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
            builder.addVertex(mat, x2, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(x2 * 16.0f), sprite.getV(y2 * 16.0f)).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
            builder.addVertex(mat, x1, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(x1 * 16.0f), sprite.getV(y2 * 16.0f)).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        }
        if (nx) {
            builder.addVertex(mat, x1, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16.0f), sprite.getV(y1 * 16.0f)).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
            builder.addVertex(mat, x1, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16.0f), sprite.getV(y1 * 16.0f)).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
            builder.addVertex(mat, x1, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16.0f), sprite.getV(y2 * 16.0f)).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
            builder.addVertex(mat, x1, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16.0f), sprite.getV(y2 * 16.0f)).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        }
        if (px) {
            builder.addVertex(mat, x2, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16.0f), sprite.getV(y1 * 16.0f)).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
            builder.addVertex(mat, x2, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16.0f), sprite.getV(y1 * 16.0f)).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
            builder.addVertex(mat, x2, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16.0f), sprite.getV(y2 * 16.0f)).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
            builder.addVertex(mat, x2, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16.0f), sprite.getV(y2 * 16.0f)).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
        }
    }
}

