/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.network;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.capability.ReputationImpl;
import alexthw.eidolon_repraised.network.AbstractPacket;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ReputationUpdatePacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<ReputationUpdatePacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("reputation_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ReputationUpdatePacket> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, pkt -> pkt.uuid, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, pkt -> pkt.tag, (StreamCodec)ByteBufCodecs.BOOL, pkt -> pkt.playSound, ReputationUpdatePacket::new);
    final UUID uuid;
    CompoundTag tag;
    final boolean playSound;

    public ReputationUpdatePacket(UUID uuid, CompoundTag tag, boolean playSound) {
        this.uuid = uuid;
        this.tag = tag;
        this.playSound = playSound;
    }

    public ReputationUpdatePacket(Player entity, boolean playSound) {
        this.uuid = entity.getUUID();
        ReputationImpl k = (ReputationImpl)entity.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
        if (k != null) {
            this.tag = k.serializeNBT((HolderLookup.Provider)entity.registryAccess());
        }
        this.playSound = playSound;
    }

    public static void encode(ReputationUpdatePacket object, FriendlyByteBuf buffer) {
        buffer.writeUUID(object.uuid);
        buffer.writeNbt((Tag)object.tag);
        buffer.writeBoolean(object.playSound);
    }

    public static ReputationUpdatePacket decode(FriendlyByteBuf buffer) {
        return new ReputationUpdatePacket(buffer.readUUID(), buffer.readNbt(), buffer.readBoolean());
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        ReputationImpl k;
        Level world = player.level();
        if (player.getUUID().equals(this.uuid) && (k = (ReputationImpl)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY)) != null) {
            k.deserializeNBT((HolderLookup.Provider)player.registryAccess(), this.tag);
            if (this.playSound) {
                player.playSound(SoundEvents.PLAYER_LEVELUP, 1.0f, 0.5f);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<ReputationUpdatePacket> type() {
        return TYPE;
    }
}

