/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.ritual;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.ritual.IRitualItemFocus;
import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.common.item.SummoningStaffItem;
import alexthw.eidolon_repraised.common.spell.ThrallSpell;
import alexthw.eidolon_repraised.network.MagicBurstEffectPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.network.RitualConsumePacket;
import alexthw.eidolon_repraised.util.ColorUtil;
import alexthw.eidolon_repraised.util.EntityUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AbsorptionRitual
extends Ritual {
    public static final ResourceLocation SYMBOL = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"particle/absorption_ritual");

    public AbsorptionRitual() {
        super(SYMBOL, ColorUtil.packColor(255, 123, 140, 70));
    }

    @Override
    public Ritual cloneRitual() {
        return new AbsorptionRitual();
    }

    @Override
    public Ritual.RitualResult start(Level world, BlockPos pos) {
        if (world.isClientSide) {
            return Ritual.RitualResult.TERMINATE;
        }
        List<IRitualItemFocus> tiles = Ritual.getTilesWithinAABB(IRitualItemFocus.class, world, this.getSearchBounds(pos));
        BlockPos toRecharge = null;
        if (!tiles.isEmpty()) {
            for (IRitualItemFocus tile : tiles) {
                ItemStack stack = tile.provide();
                if (!(stack.getItem() instanceof SummoningStaffItem)) continue;
                toRecharge = ((BlockEntity)tile).getBlockPos();
                break;
            }
        }
        List entities = world.getEntitiesOfClass(LivingEntity.class, this.getSearchBounds(pos), e -> (Eidolon.isValidUndead(e) || e.getType().is(ThrallSpell.ENTHRALL_WHITELIST)) && !e.getType().is(ThrallSpell.ENTHRALL_BLACKLIST) && !(e instanceof Player) && !EntityUtil.isEnthralled(e) && e.getHealth() <= e.getMaxHealth() / 3.0f);
        ListTag entityTags = new ListTag();
        for (LivingEntity e2 : entities) {
            e2.setHealth(e2.getMaxHealth());
            Networking.sendToNearbyClient(world, e2.blockPosition(), (CustomPacketPayload)new MagicBurstEffectPacket(e2.getX(), e2.getY() + 0.1, e2.getZ(), ColorUtil.packColor(255, 61, 70, 35), ColorUtil.packColor(255, 36, 24, 41)));
            if (toRecharge != null) {
                Networking.sendToNearbyClient(world, toRecharge, (CustomPacketPayload)new RitualConsumePacket(e2.blockPosition().above(), toRecharge, this.getRed(), this.getGreen(), this.getBlue()));
            }
            CompoundTag eTag = e2.serializeNBT((HolderLookup.Provider)world.registryAccess());
            entityTags.add((Object)eTag);
            e2.remove(Entity.RemovalReason.KILLED);
        }
        if (!tiles.isEmpty()) {
            for (IRitualItemFocus tile : tiles) {
                ItemStack stack = tile.provide();
                Item item = stack.getItem();
                if (!(item instanceof SummoningStaffItem)) continue;
                SummoningStaffItem s = (SummoningStaffItem)item;
                tile.replace(s.addCharges(stack, entityTags));
                break;
            }
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

