/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.codex;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.codex.CodexGui;
import alexthw.eidolon_repraised.codex.RecipePage;
import alexthw.eidolon_repraised.recipe.CrucibleRecipe;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class CruciblePage
extends RecipePage<CrucibleRecipe> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/codex_crucible_page.png");

    @Override
    public CrucibleRecipe getRecipe(ResourceLocation id) {
        Recipe recipe;
        RecipeHolder recipeHolder = Eidolon.proxy.getWorld().getRecipeManager().byKey(id).orElse(null);
        if (recipeHolder == null || !((recipe = recipeHolder.value()) instanceof CrucibleRecipe)) {
            return null;
        }
        CrucibleRecipe recipe2 = (CrucibleRecipe)recipe;
        return recipe2;
    }

    public CruciblePage(ItemStack result, ResourceLocation id) {
        super(BACKGROUND, id, result);
    }

    public CruciblePage(ItemStack result) {
        this(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()));
    }

    public CruciblePage(Item result) {
        this(result.getDefaultInstance(), BuiltInRegistries.ITEM.getKey((Object)result));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics guiGraphics, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        int ty;
        if (this.cachedRecipe == null) {
            return;
        }
        List<CrucibleRecipe.Step> steps = ((CrucibleRecipe)this.cachedRecipe).getSteps();
        int h = steps.size() * 20 + 32;
        int yoff = 80 - h / 2;
        for (int i = 0; i < steps.size(); ++i) {
            int j;
            int tx = x;
            ty = y + yoff + i * 20;
            guiGraphics.blit(bg, tx, ty, 128, 0, 128, 20);
            tx += 24;
            for (j = 0; j < steps.get(i).matches().size(); ++j) {
                if (steps.get(i).matches().get(j).isEmpty()) continue;
                guiGraphics.blit(bg, tx, ty + 1, 176, 32, 16, 17);
                tx += 17;
            }
            for (j = 0; j < steps.get(i).stirs(); ++j) {
                guiGraphics.blit(bg, tx, ty + 1, 192, 32, 16, 17);
                tx += 17;
            }
        }
        guiGraphics.blit(bg, x, y + yoff + steps.size() * 20, 128, 64, 128, 32);
        Font font = Minecraft.getInstance().font;
        for (int i = 0; i < steps.size(); ++i) {
            ty = y + yoff + i * 20;
            String string = I18n.get((String)("enchantment.level." + (i + 1)), (Object[])new Object[0]) + ".";
            Objects.requireNonNull(font);
            CruciblePage.drawText(guiGraphics, string, x + 7, ty + 17 - 9);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderIngredients(CodexGui gui, GuiGraphics mStack, int x, int y, int mouseX, int mouseY) {
        if (this.cachedRecipe == null) {
            return;
        }
        List<CrucibleRecipe.Step> steps = ((CrucibleRecipe)this.cachedRecipe).getSteps();
        int h = steps.size() * 20 + 32;
        int yoff = 80 - h / 2;
        for (int i = 0; i < steps.size(); ++i) {
            int tx = x;
            int ty = y + yoff + i * 20;
            tx += 24;
            List<Ingredient> matches = steps.get(i).matches();
            for (Ingredient match : matches) {
                if (match.isEmpty()) continue;
                CruciblePage.drawItems(mStack, match, tx, ty + 1, mouseX, mouseY);
                tx += 17;
            }
        }
        CruciblePage.drawItem(mStack, this.result, x + 56, y + yoff + steps.size() * 20 + 11, mouseX, mouseY);
    }
}

