/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.capability;

import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.capability.ReputationEntry;
import alexthw.eidolon_repraised.common.spell.PrayerSpell;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.network.ReputationUpdatePacket;
import alexthw.eidolon_repraised.registries.EidolonAttachments;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class ReputationImpl
implements IReputation {
    ReputationData reputationData;
    Player player;

    public ReputationImpl(Player player) {
        this.player = player;
        this.reputationData = (ReputationData)player.getData(EidolonAttachments.REPUTATION_ATTACHMENT);
    }

    @Override
    public double getReputation(ResourceLocation deity) {
        return this.reputationData.getReputation(deity);
    }

    @Override
    public void addReputation(ResourceLocation deity, double amount) {
        this.reputationData.addReputation(deity, amount);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Networking.sendToPlayerClient(new ReputationUpdatePacket(this.player, false), serverPlayer);
        }
    }

    @Override
    public void subtractReputation(ResourceLocation deity, double amount) {
        this.reputationData.subtractReputation(deity, amount);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Networking.sendToPlayerClient(new ReputationUpdatePacket(this.player, false), serverPlayer);
        }
    }

    @Override
    public void setReputation(ResourceLocation deity, double amount) {
        this.reputationData.setReputation(deity, amount);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Networking.sendToPlayerClient(new ReputationUpdatePacket(this.player, false), serverPlayer);
        }
    }

    @Override
    public boolean isLocked(Player player, ResourceLocation deity) {
        return this.reputationData.isLocked(deity);
    }

    @Override
    public boolean hasLock(Player player, ResourceLocation deity, ResourceLocation lock) {
        return this.reputationData.hasLock(deity, lock);
    }

    @Override
    public void lock(Player player, ResourceLocation deity, ResourceLocation key) {
        this.reputationData.lock(deity, key);
    }

    @Override
    public boolean unlock(Player player, ResourceLocation deity, ResourceLocation key) {
        return this.reputationData.unlock(deity, key);
    }

    @Override
    public void pray(PrayerSpell spell, long time) {
        this.reputationData.pray(spell, time);
    }

    @Override
    public boolean canPray(PrayerSpell spell, long time) {
        return this.reputationData.canPray(spell, time);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.reputationData.serializeNBT(provider);
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        this.reputationData.deserializeNBT(provider, nbt);
        this.player.setData(EidolonAttachments.REPUTATION_ATTACHMENT.get(), (Object)this.reputationData);
    }

    public static class ReputationData
    implements INBTSerializable<CompoundTag> {
        private final Map<ResourceLocation, ReputationEntry> reputationMap = new HashMap<ResourceLocation, ReputationEntry>();
        private final Map<ResourceLocation, Long> prayerTimes = new HashMap<ResourceLocation, Long>();

        public double getReputation(ResourceLocation deity) {
            return this.reputationMap.computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getReputation$0(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lalexthw/eidolon_repraised/capability/ReputationEntry;)()).reputation;
        }

        public void addReputation(ResourceLocation deity, double amount) {
            ReputationEntry entry = this.reputationMap.computeIfAbsent(deity, k -> new ReputationEntry());
            if (entry.lock == null) {
                entry.reputation += amount;
            }
        }

        public void subtractReputation(ResourceLocation deity, double amount) {
            ReputationEntry entry = this.reputationMap.computeIfAbsent(deity, k -> new ReputationEntry());
            entry.reputation = Math.max(0.0, entry.reputation - amount);
        }

        public void setReputation(ResourceLocation deity, double amount) {
            ReputationEntry entry = this.reputationMap.computeIfAbsent(deity, k -> new ReputationEntry());
            if (entry.lock == null || amount < 0.0) {
                entry.reputation = amount;
            }
        }

        public boolean isLocked(ResourceLocation deity) {
            return this.reputationMap.computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$isLocked$4(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lalexthw/eidolon_repraised/capability/ReputationEntry;)()).lock != null;
        }

        public boolean hasLock(ResourceLocation deity, ResourceLocation lock) {
            ResourceLocation l = this.reputationMap.computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$hasLock$5(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lalexthw/eidolon_repraised/capability/ReputationEntry;)()).lock;
            return l != null && l.equals((Object)lock);
        }

        public void lock(ResourceLocation deity, ResourceLocation key) {
            this.reputationMap.computeIfAbsent((ResourceLocation)deity, (Function<ResourceLocation, ReputationEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$lock$6(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lalexthw/eidolon_repraised/capability/ReputationEntry;)()).lock = key;
        }

        public boolean unlock(ResourceLocation deity, ResourceLocation key) {
            ReputationEntry entry = this.reputationMap.computeIfAbsent(deity, k -> new ReputationEntry());
            if (entry.lock != null && entry.lock.equals((Object)key)) {
                entry.lock = null;
                return true;
            }
            return false;
        }

        public void pray(PrayerSpell spell, long time) {
            this.prayerTimes.put(spell.getRegistryName(), time);
        }

        public boolean canPray(PrayerSpell spell, long time) {
            return !this.prayerTimes.containsKey(spell.getRegistryName()) || this.prayerTimes.get(spell.getRegistryName()) < time - (long)spell.getCooldown();
        }

        public Map<ResourceLocation, ReputationEntry> getReputationMap() {
            return this.reputationMap;
        }

        public Map<ResourceLocation, Long> getPrayerTimes() {
            return this.prayerTimes;
        }

        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            CompoundTag data = new CompoundTag();
            CompoundTag reps = new CompoundTag();
            for (Map.Entry<ResourceLocation, ReputationEntry> e : this.reputationMap.entrySet()) {
                CompoundTag entry = new CompoundTag();
                entry.putDouble("rep", e.getValue().reputation);
                if (e.getValue().lock != null) {
                    entry.putString("lock", e.getValue().lock.toString());
                }
                reps.put(e.getKey().toString(), (Tag)entry);
            }
            CompoundTag times = new CompoundTag();
            for (Map.Entry<ResourceLocation, Long> e : this.prayerTimes.entrySet()) {
                times.putLong(e.getKey().toString(), e.getValue().longValue());
            }
            data.put("reps", (Tag)reps);
            data.put("times", (Tag)times);
            return data;
        }

        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            this.reputationMap.clear();
            this.prayerTimes.clear();
            if (nbt.contains("reps")) {
                CompoundTag reps = nbt.getCompound("reps");
                for (String deity : reps.getAllKeys()) {
                    CompoundTag entry = reps.getCompound(deity);
                    double rep = entry.getDouble("rep");
                    ResourceLocation lock = entry.contains("lock") ? ResourceLocation.parse((String)entry.getString("lock")) : null;
                    this.reputationMap.put(ResourceLocation.parse((String)deity), new ReputationEntry(rep, lock));
                }
            }
            if (nbt.contains("times")) {
                CompoundTag times = nbt.getCompound("times");
                for (String rl : times.getAllKeys()) {
                    this.prayerTimes.put(ResourceLocation.parse((String)rl), times.getLong(rl));
                }
            }
        }

        private static /* synthetic */ ReputationEntry lambda$lock$6(ResourceLocation k) {
            return new ReputationEntry();
        }

        private static /* synthetic */ ReputationEntry lambda$hasLock$5(ResourceLocation k) {
            return new ReputationEntry();
        }

        private static /* synthetic */ ReputationEntry lambda$isLocked$4(ResourceLocation k) {
            return new ReputationEntry();
        }

        private static /* synthetic */ ReputationEntry lambda$getReputation$0(ResourceLocation k) {
            return new ReputationEntry();
        }
    }
}

