/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.api.deity;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.api.deity.ReputationEvent;
import alexthw.eidolon_repraised.api.research.Research;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import alexthw.eidolon_repraised.util.RGBProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public abstract class Deity
implements RGBProvider {
    protected final ResourceLocation id;
    final int red;
    final int green;
    final int blue;
    protected final Progression progression;

    public Progression getProgression() {
        return this.progression;
    }

    public Deity(ResourceLocation id, int red, int green, int blue) {
        this.id = id;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.progression = new Progression(new Stage(Eidolon.prefix("start"), 0, true));
    }

    @Override
    public float getRed() {
        return (float)this.red / 255.0f;
    }

    @Override
    public float getGreen() {
        return (float)this.green / 255.0f;
    }

    @Override
    public float getBlue() {
        return (float)this.blue / 255.0f;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void onReputationChange(Player player, IReputation rep, double prev, double updated) {
        double curr;
        if (((ReputationEvent.Change)NeoForge.EVENT_BUS.post((Event)new ReputationEvent.Change(this, player, prev, updated))).isCanceled()) {
            return;
        }
        Stage nextStage = this.progression.tryProgress(rep, player, prev, updated);
        Stage currStage = this.progression.next(prev == 0.0 ? 1.0 : prev);
        if (nextStage == null) {
            rep.setReputation(this.id, this.progression.max);
            return;
        }
        if (nextStage.rep > currStage.rep) {
            if (((ReputationEvent.Unlock)NeoForge.EVENT_BUS.post((Event)new ReputationEvent.Unlock(this, player, nextStage))).isCanceled()) {
                return;
            }
            this.onReputationUnlock(player, currStage.id());
        }
        if ((curr = rep.getReputation(this.getId())) == (double)nextStage.rep() && updated != curr) {
            if (((ReputationEvent.Lock)NeoForge.EVENT_BUS.post((Event)new ReputationEvent.Lock(this, player, currStage))).isCanceled()) {
                return;
            }
            this.onReputationLock(player, currStage.id());
        }
    }

    public abstract void onReputationUnlock(Player var1, ResourceLocation var2);

    public abstract void onReputationLock(Player var1, ResourceLocation var2);

    public class Progression {
        final TreeMap<Integer, Stage> steps = new TreeMap();
        public int max;

        public TreeMap<Integer, Stage> getSteps() {
            return this.steps;
        }

        public void setMax(int max) {
            this.steps.put(max, new Stage(Eidolon.prefix("end"), max, true));
            this.max = max;
        }

        public Progression(Stage ... stages) {
            for (Stage s : stages) {
                this.steps.put(s.rep, s);
            }
            this.max = this.steps.lastKey();
        }

        public Progression add(Stage stage) {
            this.steps.put(stage.rep, stage);
            this.max = this.steps.lastKey();
            return this;
        }

        public Stage next(double rep) {
            return this.steps.ceilingEntry(Mth.clamp((int)((int)(rep + 0.5)), (int)0, (int)this.max)).getValue();
        }

        public Stage last(double rep) {
            return this.steps.floorEntry((int)rep).getValue();
        }

        public Stage prev(double rep) {
            return this.steps.floorEntry(this.steps.floorKey((int)Math.max(rep - 0.5, 0.0))).getValue();
        }

        public Stage tryProgress(IReputation rep, Player player, double prev, double current) {
            if (current >= (double)this.max) {
                return null;
            }
            Stage s = this.next(prev == 0.0 ? 1.0 : prev);
            if (current > (double)s.rep) {
                if (s.satisfiedBy(player)) {
                    Stage next = this.next(s.rep + 1);
                    rep.setReputation(Deity.this.getId(), Math.min(current, (double)next.rep));
                    return next;
                }
                rep.setReputation(Deity.this.getId(), s.rep);
            }
            return s;
        }

        public void regress(IReputation rep, Player player) {
            double level = rep.getReputation(Deity.this.getId());
            Stage s = this.prev(level);
            rep.setReputation(Deity.this.getId(), Math.min(level, (double)s.rep));
        }
    }

    public record Stage(ResourceLocation id, int rep, boolean major, List<StageRequirement> reqs) {
        public Stage(ResourceLocation id, int rep, boolean major) {
            this(id, rep, major, new ArrayList<StageRequirement>());
        }

        public Stage requirement(StageRequirement req) {
            this.reqs.add(req);
            return this;
        }

        boolean satisfiedBy(Player player) {
            boolean satisfied = true;
            for (StageRequirement req : this.reqs) {
                if (req.isMet(player)) continue;
                satisfied = false;
                break;
            }
            return satisfied;
        }
    }

    public static class SignRequirement
    implements StageRequirement {
        final Sign sign;

        public SignRequirement(Sign sign) {
            this.sign = sign;
        }

        @Override
        public boolean isMet(Player player) {
            return KnowledgeUtil.knowsSign(player, this.sign);
        }
    }

    public static class ResearchRequirement
    implements StageRequirement {
        final ResourceLocation r;

        public ResearchRequirement(Research r) {
            this.r = r.getRegistryName();
        }

        public ResearchRequirement(ResourceLocation r) {
            this.r = r;
        }

        @Override
        public boolean isMet(Player player) {
            return KnowledgeUtil.knowsResearch(player, this.r);
        }
    }

    public static interface StageRequirement {
        public boolean isMet(Player var1);
    }
}

