/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.api.ritual.FocusItemPresentRequirement;
import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.recipe.RitualRecipe;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import alexthw.eidolon_repraised.registries.RitualRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class GenericRitualRecipe
extends RitualRecipe {
    ResourceLocation ritualRL;

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.ritualRL;
    }

    public GenericRitualRecipe(ResourceLocation ritualRL, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, List<Ingredient> invariants, float healthRequirement) {
        super(reagent, pedestalItems, focusItems, invariants, healthRequirement);
        this.ritualRL = ritualRL;
    }

    @Override
    public Ritual getRitualWithRequirements() {
        Ritual ritual = super.getRitualWithRequirements();
        if (!this.invariantItems.isEmpty()) {
            ritual.addInvariants(this.invariantItems.stream().map(FocusItemPresentRequirement::new).collect(Collectors.toList()));
        }
        return ritual;
    }

    @Override
    public boolean isMatch(List<ItemStack> pedestalItems, List<ItemStack> focusItems, ItemStack reagent) {
        if (!this.invariantItems.isEmpty()) {
            focusItems.removeIf(i -> this.invariantItems.stream().anyMatch(ing -> ing.test(i)));
        }
        return super.isMatch(pedestalItems, focusItems, reagent);
    }

    @Override
    public Ritual getRitual() {
        return RitualRegistry.find(this.ritualRL);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.RITUAL_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.RITUAL_TYPE.get();
    }

    public static class Serializer
    extends RitualRecipe.Serializer<GenericRitualRecipe> {
        public static final MapCodec<GenericRitualRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("ritual").forGetter(recipe -> recipe.ritualRL), (App)Ingredient.CODEC.fieldOf("reagent").forGetter(recipe -> recipe.reagent), (App)Ingredient.CODEC.listOf().fieldOf("pedestal_items").forGetter(recipe -> recipe.pedestalItems), (App)Ingredient.CODEC.listOf().fieldOf("focus_items").forGetter(recipe -> recipe.focusItems), (App)Ingredient.CODEC.listOf().fieldOf("invariant_items").forGetter(recipe -> recipe.invariantItems), (App)Codec.FLOAT.fieldOf("health_requirement").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.healthRequirement))).apply((Applicative)instance, GenericRitualRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GenericRitualRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, GenericRitualRecipe::getId, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RitualRecipe::getReagent, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getPedestalItems, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getFocusItems, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getInvariantItems, (StreamCodec)ByteBufCodecs.FLOAT, RitualRecipe::getHealthRequirement, GenericRitualRecipe::new);

        @NotNull
        public MapCodec<GenericRitualRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, GenericRitualRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

