/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item.curio;

import alexthw.eidolon_repraised.api.capability.ISoul;
import alexthw.eidolon_repraised.capability.SoulImpl;
import alexthw.eidolon_repraised.common.item.ItemBase;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.network.SoulUpdatePacket;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class SoulboneAmuletItem
extends ItemBase
implements ICurioItem {
    public SoulboneAmuletItem(Item.Properties properties) {
        super(properties);
        NeoForge.EVENT_BUS.addListener(SoulboneAmuletItem::onKill);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        LivingEntity e;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity && CuriosApi.getCuriosInventory((LivingEntity)(e = (LivingEntity)entity)).flatMap(i -> i.findFirstCurio((Item)Registry.SOULBONE_AMULET.get())).isPresent()) {
            SoulImpl cap = (SoulImpl)e.getCapability(EidolonCapabilities.SOUL_HEART_CAPABILITY);
            if (cap == null) {
                return;
            }
            cap.setMaxEtherealHealth(Math.max(Math.min(ISoul.getPersistentHealth(e), cap.getMaxEtherealHealth()), (float)(2 * Mth.floor((float)((cap.getEtherealHealth() + 3.0f) / 2.0f)))));
            cap.setEtherealHealth(cap.getEtherealHealth() + 2.0f);
            if (e instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)e;
                Networking.sendToPlayerClient(new SoulUpdatePacket(e), serverPlayer);
            }
        }
    }
}

