/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item.curio;

import alexthw.eidolon_repraised.capability.WingsDataImpl;
import alexthw.eidolon_repraised.common.item.IWingsItem;
import alexthw.eidolon_repraised.common.item.curio.EidolonCurio;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class RavenCloakItem
extends EidolonCurio
implements IWingsItem {
    UUID ATTR_ID = new UUID(261693807752044433L, 1154961640602571210L);
    public static final int MAX_CHARGES = 10;

    public RavenCloakItem(Item.Properties properties) {
        super(properties);
        NeoForge.EVENT_BUS.addListener(RavenCloakItem::onFall);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (CuriosApi.getCuriosInventory((LivingEntity)event.getEntity()).flatMap(i -> i.findFirstCurio((Item)Registry.GRAVITY_BELT.get())).isPresent()) {
            event.setDistance(event.getDistance() / 4.0f);
        }
    }

    @Override
    public int getMaxCharges(ItemStack stack) {
        return 10;
    }

    @Override
    public void onFlap(Player player, Level level, ItemStack stack, int nCharges) {
        player.setDeltaMovement(player.getDeltaMovement().add(player.getLookAngle().scale(0.25)).multiply(1.0, 0.0, 1.0).add(0.0, 0.5, 0.0));
    }

    @Override
    public int getDashTicks(ItemStack stack) {
        return 100;
    }

    @Override
    public void onDashStart(Player player, Level level, ItemStack stack) {
    }

    @Override
    public void onDashTick(Player player, Level level, ItemStack stack, int remainingTicks) {
        float coeff = (float)remainingTicks / (float)this.getDashTicks(stack);
        coeff = 1.0f - (1.0f - coeff) * (1.0f - coeff) + 0.25f;
        player.setDeltaMovement(player.getDeltaMovement().scale(0.8).add(player.getLookAngle().scale((double)coeff * 0.2)));
    }

    @Override
    public void onDashEnd(Player player, Level level, ItemStack stack) {
    }

    @Override
    public void onDashFlap(Player player, Level level, ItemStack stack, int dashTicks) {
        WingsDataImpl cap = (WingsDataImpl)player.getCapability(EidolonCapabilities.WINGS_CAPABILITY);
        if (cap != null) {
            cap.setDashTicks(this.getDashTicks(stack));
        }
    }
}

