/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client;

import alexthw.eidolon_repraised.client.model.BruteSkeletonModel;
import alexthw.eidolon_repraised.client.model.NecromancerModel;
import alexthw.eidolon_repraised.client.model.RavenModel;
import alexthw.eidolon_repraised.client.model.SlimySlugModel;
import alexthw.eidolon_repraised.client.model.WraithModel;
import alexthw.eidolon_repraised.client.model.ZombieBruteModel;
import alexthw.eidolon_repraised.client.renderer.ChantCasterRenderer;
import alexthw.eidolon_repraised.client.renderer.GiantSkeletonRenderer;
import alexthw.eidolon_repraised.client.renderer.NecromancerRenderer;
import alexthw.eidolon_repraised.client.renderer.RavenRenderer;
import alexthw.eidolon_repraised.client.renderer.SlimySlugRenderer;
import alexthw.eidolon_repraised.client.renderer.WraithRenderer;
import alexthw.eidolon_repraised.client.renderer.ZombieBruteRenderer;
import alexthw.eidolon_repraised.common.item.ChantScrollItem;
import alexthw.eidolon_repraised.common.item.curio.RavenCloakRenderer;
import alexthw.eidolon_repraised.common.item.curio.SanguineAmuletItem;
import alexthw.eidolon_repraised.common.item.model.BonelordArmorModel;
import alexthw.eidolon_repraised.common.item.model.RavenCloakModel;
import alexthw.eidolon_repraised.common.item.model.SilverArmorModel;
import alexthw.eidolon_repraised.common.item.model.TopHatModel;
import alexthw.eidolon_repraised.common.item.model.WarlockArmorModel;
import alexthw.eidolon_repraised.common.tile.CrucibleTileRenderer;
import alexthw.eidolon_repraised.registries.EidolonEntities;
import alexthw.eidolon_repraised.registries.Registry;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@EventBusSubscriber(modid="eidolon_repraised", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientRegistry {
    public static final ModelLayerLocation SILVER_ARMOR_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"silver_armor"), "main");
    public static final ModelLayerLocation WARLOCK_ARMOR_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"warlock_armor"), "main");
    public static final ModelLayerLocation BONELORD_ARMOR_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"bonelord_armor"), "main");
    public static final ModelLayerLocation TOP_HAT_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"top_hat"), "main");
    public static final ModelLayerLocation RAVEN_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"raven"), "main");
    public static final ModelLayerLocation NECROMANCER_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"necromancer"), "main");
    public static final ModelLayerLocation WRAITH_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"wraith"), "main");
    public static final ModelLayerLocation ZOMBIE_BRUTE_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"zombie_brute"), "main");
    public static final ModelLayerLocation SLUG_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"slimy_slug"), "main");
    public static final ModelLayerLocation GIANT_SKEL_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"giant_skeleton"), "main");
    public static final ModelLayerLocation CRUCIBLE_STIRRER_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"crucible_stirrer"), "main");
    public static final ModelLayerLocation RAVEN_CLOAK_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"raven_cloak"), "main");
    public static WarlockArmorModel WARLOCK_ARMOR_MODEL = null;
    public static BonelordArmorModel BONELORD_ARMOR_MODEL = null;
    public static TopHatModel TOP_HAT_MODEL = null;
    public static SilverArmorModel SILVER_ARMOR_MODEL = null;
    public static ZombieBruteModel ZOMBIE_BRUTE_MODEL = null;
    public static BruteSkeletonModel GIANT_SKEL_MODEL = null;
    public static WraithModel WRAITH_MODEL = null;
    public static RavenModel RAVEN_MODEL = null;
    public static NecromancerModel NECROMANCER_MODEL = null;
    public static SlimySlugModel SLUG_MODEL = null;
    public static ShaderInstance GLOWING_SHADER;
    public static ShaderInstance GLOWING_SPRITE_SHADER;
    public static ShaderInstance GLOWING_PARTICLE_SHADER;
    public static ShaderInstance VAPOR_SHADER;
    public static ShaderInstance GLOWING_ENTITY_SHADER;
    public static ShaderInstance SPRITE_PARTICLE_SHADER;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(SanguineAmuletItem.SanguineAmuletTooltipInfo.class, SanguineAmuletItem.SanguineAmuletTooltipComponent::new);
        event.register(ChantScrollItem.ChantTooltipInfo.class, ChantScrollItem.ChantTooltipComponent::new);
    }

    @SubscribeEvent
    public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(WARLOCK_ARMOR_LAYER, WarlockArmorModel::createBodyLayer);
        event.registerLayerDefinition(BONELORD_ARMOR_LAYER, BonelordArmorModel::createBodyLayer);
        event.registerLayerDefinition(TOP_HAT_LAYER, TopHatModel::createBodyLayer);
        event.registerLayerDefinition(SILVER_ARMOR_LAYER, SilverArmorModel::createBodyLayer);
        event.registerLayerDefinition(RAVEN_CLOAK_LAYER, RavenCloakModel::createBodyLayer);
        event.registerLayerDefinition(RAVEN_LAYER, RavenModel::createBodyLayer);
        event.registerLayerDefinition(ZOMBIE_BRUTE_LAYER, ZombieBruteModel::createBodyLayer);
        event.registerLayerDefinition(WRAITH_LAYER, WraithModel::createBodyLayer);
        event.registerLayerDefinition(NECROMANCER_LAYER, NecromancerModel::createBodyLayer);
        event.registerLayerDefinition(SLUG_LAYER, SlimySlugModel::createBodyLayer);
        event.registerLayerDefinition(GIANT_SKEL_LAYER, BruteSkeletonModel::createBodyLayer);
        event.registerLayerDefinition(CRUCIBLE_STIRRER_LAYER, CrucibleTileRenderer::createModelLayer);
    }

    @SubscribeEvent
    public static void onRegisterLayers(EntityRenderersEvent.AddLayers event) {
        WARLOCK_ARMOR_MODEL = new WarlockArmorModel(event.getEntityModels().bakeLayer(WARLOCK_ARMOR_LAYER));
        BONELORD_ARMOR_MODEL = new BonelordArmorModel(event.getEntityModels().bakeLayer(BONELORD_ARMOR_LAYER));
        TOP_HAT_MODEL = new TopHatModel(event.getEntityModels().bakeLayer(TOP_HAT_LAYER));
        SILVER_ARMOR_MODEL = new SilverArmorModel(event.getEntityModels().bakeLayer(SILVER_ARMOR_LAYER));
        RAVEN_MODEL = new RavenModel(event.getEntityModels().bakeLayer(RAVEN_LAYER));
        ZOMBIE_BRUTE_MODEL = new ZombieBruteModel(event.getEntityModels().bakeLayer(ZOMBIE_BRUTE_LAYER));
        GIANT_SKEL_MODEL = new BruteSkeletonModel(event.getEntityModels().bakeLayer(GIANT_SKEL_LAYER));
        WRAITH_MODEL = new WraithModel(event.getEntityModels().bakeLayer(WRAITH_LAYER));
        NECROMANCER_MODEL = new NecromancerModel(event.getEntityModels().bakeLayer(NECROMANCER_LAYER));
        SLUG_MODEL = new SlimySlugModel(event.getEntityModels().bakeLayer(SLUG_LAYER));
    }

    @SubscribeEvent
    public static void onRegisterEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        EntityRenderers.register((EntityType)((EntityType)EidolonEntities.ZOMBIE_BRUTE.get()), ZombieBruteRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)EidolonEntities.GIANT_SKEL.get()), GiantSkeletonRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)EidolonEntities.WRAITH.get()), WraithRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)EidolonEntities.NECROMANCER.get()), NecromancerRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)EidolonEntities.SOULFIRE_PROJECTILE.get()), NoopRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)EidolonEntities.BONECHILL_PROJECTILE.get()), NoopRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)EidolonEntities.NECROMANCER_SPELL.get()), NoopRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)EidolonEntities.CHANT_CASTER.get()), ChantCasterRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)EidolonEntities.RAVEN.get()), RavenRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)EidolonEntities.SLIMY_SLUG.get()), SlimySlugRenderer::new);
    }

    public static ShaderInstance getGlowingShader() {
        return GLOWING_SHADER;
    }

    public static ShaderInstance getGlowingSpriteShader() {
        return GLOWING_SPRITE_SHADER;
    }

    public static ShaderInstance getGlowingParticleShader() {
        return GLOWING_PARTICLE_SHADER;
    }

    public static ShaderInstance getGlowingEntityShader() {
        return GLOWING_ENTITY_SHADER;
    }

    public static ShaderInstance getVaporShader() {
        return VAPOR_SHADER;
    }

    public static ShaderInstance getSpriteParticleShader() {
        return SPRITE_PARTICLE_SHADER;
    }

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"glowing"), DefaultVertexFormat.POSITION_COLOR), shader -> {
            GLOWING_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"glowing_sprite"), DefaultVertexFormat.POSITION_TEX_COLOR), shader -> {
            GLOWING_SPRITE_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"glowing_particle"), DefaultVertexFormat.PARTICLE), shader -> {
            GLOWING_PARTICLE_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"glowing_entity"), DefaultVertexFormat.NEW_ENTITY), shader -> {
            GLOWING_ENTITY_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"vapor"), DefaultVertexFormat.BLOCK), shader -> {
            VAPOR_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"sprite_particle"), DefaultVertexFormat.PARTICLE), shader -> {
            SPRITE_PARTICLE_SHADER = shader;
        });
    }

    public static void initCurios() {
        CuriosRendererRegistry.register((Item)((Item)Registry.RAVEN_CLOAK.get()), RavenCloakRenderer::new);
    }
}

