/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.registries;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.common.ritual.AbsorptionRitual;
import alexthw.eidolon_repraised.common.ritual.AllureRitual;
import alexthw.eidolon_repraised.common.ritual.CrystalRitual;
import alexthw.eidolon_repraised.common.ritual.DaylightRitual;
import alexthw.eidolon_repraised.common.ritual.DeceitRitual;
import alexthw.eidolon_repraised.common.ritual.MoonlightRitual;
import alexthw.eidolon_repraised.common.ritual.PurifyRitual;
import alexthw.eidolon_repraised.common.ritual.RechargingRitual;
import alexthw.eidolon_repraised.common.ritual.RepellingRitual;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class RitualRegistry {
    static final Map<ResourceLocation, Ritual> rituals = new HashMap<ResourceLocation, Ritual>();
    public static Ritual CRYSTAL_RITUAL;
    public static Ritual SUMMON_ZOMBIE;
    public static Ritual SUMMON_SKELETON;
    public static Ritual SUMMON_PHANTOM;
    public static Ritual SUMMON_HUSK;
    public static Ritual SUMMON_DROWNED;
    public static Ritual SUMMON_STRAY;
    public static Ritual SUMMON_WITHER_SKELETON;
    public static Ritual SUMMON_WRAITH;
    public static Ritual ALLURE_RITUAL;
    public static Ritual REPELLING_RITUAL;
    public static Ritual DECEIT_RITUAL;
    public static Ritual DAYLIGHT_RITUAL;
    public static Ritual MOONLIGHT_RITUAL;
    public static Ritual PURIFY_RITUAL;
    public static Ritual RECHARGE_SOULFIRE_RITUAL;
    public static Ritual RECHARGE_BONECHILL_RITUAL;
    public static Ritual SANGUINE_SWORD;
    public static Ritual SANGUINE_AMULET;
    public static Ritual ABSORB_RITUAL;
    public static ResourceLocation CRYSTAL_RITUAL_RL;
    public static ResourceLocation ALLURE_RITUAL_RL;
    public static ResourceLocation REPELLING_RITUAL_RL;
    public static ResourceLocation DECEIT_RITUAL_RL;
    public static ResourceLocation DAYLIGHT_RITUAL_RL;
    public static ResourceLocation MOONLIGHT_RITUAL_RL;
    public static ResourceLocation PURIFY_RITUAL_RL;
    public static ResourceLocation RECHARGE_SOULFIRE_RITUAL_RL;
    public static ResourceLocation RECHARGE_BONECHILL_RITUAL_RL;
    public static ResourceLocation ABSORB_RITUAL_RL;

    public static Ritual register(ResourceLocation name, Ritual ritual) {
        assert (name != null);
        ritual.setRegistryName(name);
        rituals.put(name, ritual);
        return ritual;
    }

    public static Ritual find(ResourceLocation name) {
        return rituals.get(name);
    }

    public static void init() {
        CRYSTAL_RITUAL = RitualRegistry.register(CRYSTAL_RITUAL_RL, new CrystalRitual());
        DECEIT_RITUAL = RitualRegistry.register(DECEIT_RITUAL_RL, new DeceitRitual());
        ALLURE_RITUAL = RitualRegistry.register(ALLURE_RITUAL_RL, new AllureRitual());
        REPELLING_RITUAL = RitualRegistry.register(REPELLING_RITUAL_RL, new RepellingRitual());
        DAYLIGHT_RITUAL = RitualRegistry.register(DAYLIGHT_RITUAL_RL, new DaylightRitual());
        MOONLIGHT_RITUAL = RitualRegistry.register(MOONLIGHT_RITUAL_RL, new MoonlightRitual());
        PURIFY_RITUAL = RitualRegistry.register(PURIFY_RITUAL_RL, new PurifyRitual());
        RECHARGE_SOULFIRE_RITUAL = RitualRegistry.register(RECHARGE_SOULFIRE_RITUAL_RL, new RechargingRitual());
        RECHARGE_BONECHILL_RITUAL = RitualRegistry.register(RECHARGE_BONECHILL_RITUAL_RL, new RechargingRitual());
        ABSORB_RITUAL = RitualRegistry.register(ABSORB_RITUAL_RL, new AbsorptionRitual());
    }

    static {
        CRYSTAL_RITUAL_RL = Eidolon.prefix("crystal");
        ALLURE_RITUAL_RL = Eidolon.prefix("allure");
        REPELLING_RITUAL_RL = Eidolon.prefix("repelling");
        DECEIT_RITUAL_RL = Eidolon.prefix("deceit");
        DAYLIGHT_RITUAL_RL = Eidolon.prefix("daylight");
        MOONLIGHT_RITUAL_RL = Eidolon.prefix("moonlight");
        PURIFY_RITUAL_RL = Eidolon.prefix("purify");
        RECHARGE_SOULFIRE_RITUAL_RL = Eidolon.prefix("recharging_soulfire");
        RECHARGE_BONECHILL_RITUAL_RL = Eidolon.prefix("recharging_chill");
        ABSORB_RITUAL_RL = Eidolon.prefix("absorption");
    }
}

