/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.registries;

import alexthw.eidolon_repraised.common.entity.BonechillProjectileEntity;
import alexthw.eidolon_repraised.common.entity.ChantCasterEntity;
import alexthw.eidolon_repraised.common.entity.GiantSkeletonEntity;
import alexthw.eidolon_repraised.common.entity.NecromancerEntity;
import alexthw.eidolon_repraised.common.entity.NecromancerSpellEntity;
import alexthw.eidolon_repraised.common.entity.RavenEntity;
import alexthw.eidolon_repraised.common.entity.SlimySlugEntity;
import alexthw.eidolon_repraised.common.entity.SoulfireProjectileEntity;
import alexthw.eidolon_repraised.common.entity.WraithEntity;
import alexthw.eidolon_repraised.common.entity.ZombieBruteEntity;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="eidolon_repraised")
public class EidolonEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"eidolon_repraised");
    public static final DeferredHolder<EntityType<?>, EntityType<ZombieBruteEntity>> ZOMBIE_BRUTE = EidolonEntities.addEntity("zombie_brute", 7969893, 44975, 1.2f, 2.5f, ZombieBruteEntity::new, MobCategory.MONSTER);
    public static final DeferredHolder<EntityType<?>, EntityType<GiantSkeletonEntity>> GIANT_SKEL = EidolonEntities.addEntity("giant_skeleton", 7368299, 11381949, 1.2f, 2.75f, GiantSkeletonEntity::new, MobCategory.MONSTER);
    public static final DeferredHolder<EntityType<?>, EntityType<WraithEntity>> WRAITH = EidolonEntities.addEntity("wraith", 7368299, 11381949, 0.6f, 1.9f, WraithEntity::new, MobCategory.MONSTER);
    public static final DeferredHolder<EntityType<?>, EntityType<SoulfireProjectileEntity>> SOULFIRE_PROJECTILE = EidolonEntities.addEntity("soulfire_projectile", 0.4f, 0.4f, SoulfireProjectileEntity::new, MobCategory.MISC);
    public static final DeferredHolder<EntityType<?>, EntityType<BonechillProjectileEntity>> BONECHILL_PROJECTILE = EidolonEntities.addEntity("bonechill_projectile", 0.4f, 0.4f, BonechillProjectileEntity::new, MobCategory.MISC);
    public static final DeferredHolder<EntityType<?>, EntityType<NecromancerSpellEntity>> NECROMANCER_SPELL = EidolonEntities.addEntity("necromancer_spell", 0.4f, 0.4f, NecromancerSpellEntity::new, MobCategory.MISC);
    public static final DeferredHolder<EntityType<?>, EntityType<ChantCasterEntity>> CHANT_CASTER = EidolonEntities.addEntity("chant_caster", 0.1f, 0.1f, ChantCasterEntity::new, MobCategory.MISC);
    public static final DeferredHolder<EntityType<?>, EntityType<NecromancerEntity>> NECROMANCER = EidolonEntities.addEntity("necromancer", 6890846, 10283263, 0.6f, 2.2f, NecromancerEntity::new, MobCategory.MONSTER);
    public static final DeferredHolder<EntityType<?>, EntityType<RavenEntity>> RAVEN = EidolonEntities.addEntity("raven", 1974052, 4214630, 0.375f, 0.5f, RavenEntity::new, MobCategory.CREATURE);
    public static final DeferredHolder<EntityType<?>, EntityType<SlimySlugEntity>> SLIMY_SLUG = EidolonEntities.addEntity("slimy_slug", 14410632, 6266434, 0.5f, 0.25f, SlimySlugEntity::new, MobCategory.CREATURE);

    static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> addEntity(String name, float width, float height, EntityType.EntityFactory<T> factory, MobCategory kind) {
        return ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)kind).setTrackingRange(64).setUpdateInterval(1).sized(width, height).build("eidolon_repraised:" + name));
    }

    static <T extends Mob> DeferredHolder<EntityType<?>, EntityType<T>> addEntity(String name, int color1, int color2, float width, float height, EntityType.EntityFactory<T> factory, MobCategory kind) {
        DeferredHolder type = ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)kind).setTrackingRange(64).setUpdateInterval(1).sized(width, height).build("eidolon_repraised:" + name));
        Registry.ITEMS.register("spawn_" + name, () -> new DeferredSpawnEggItem((Supplier)type, color1, color2, new Item.Properties()));
        return type;
    }

    @SubscribeEvent
    public static void spawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ZOMBIE_BRUTE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)WRAITH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)GIANT_SKEL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (pType, pLevel, pSpawnType, pPos, pRandom) -> pLevel.getDifficulty() != Difficulty.PEACEFUL && Mob.checkMobSpawnRules((EntityType)pType, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom), RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)RAVEN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)SLIMY_SLUG.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (e, w, t, pos, rand) -> true, RegisterSpawnPlacementsEvent.Operation.AND);
    }
}

