/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.incense;

import alexthw.eidolon_repraised.api.ritual.IncenseRitual;
import alexthw.eidolon_repraised.client.particle.Particles;
import alexthw.eidolon_repraised.registries.EidolonParticles;
import alexthw.eidolon_repraised.registries.EidolonPotions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class FrostbindIncense
extends IncenseRitual {
    public FrostbindIncense(ResourceLocation registryName) {
        super(2400, registryName);
    }

    @Override
    public float getRed() {
        return 0.3f;
    }

    @Override
    public float getGreen() {
        return 0.75f;
    }

    @Override
    public float getBlue() {
        return 1.0f;
    }

    @Override
    public void animateParticles(int burnCounter, BlockPos blockPos, Level level) {
        super.animateParticles(burnCounter, blockPos, level);
        double x = blockPos.getX();
        double y = blockPos.getY() + 1;
        double z = blockPos.getZ();
        if (level.random.nextInt(4) == 0) {
            for (int i = 0; i < 5; ++i) {
                Particles.spawnParticle(level, (ParticleOptions)ParticleTypes.SNOWFLAKE, x, y + 0.5, z, 0.0, -0.01, 0.0, this.range(), 0.0, this.range());
            }
            Particles.create((ParticleType)EidolonParticles.SMOKE_PARTICLE.get()).setAlpha(0.35f, 0.0f).setScale(0.375f, 0.125f).setLifetime(80).randomOffset((double)this.range() * 0.75, 0.1).randomVelocity(0.025f, 0.025f).addVelocity(0.0, -0.0125f, 0.0).setColor(0.75f, 0.95f, 1.0f, 0.005f, 0.005f, 0.005f).repeat(level, x, y + 0.125, z, 5);
        }
    }

    @Override
    public void tickEffect(int age) {
        if (age % 10 == 0) {
            Level level = this.censer.getLevel();
            BlockPos pos = this.censer.getBlockPos();
            assert (level != null);
            for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate((double)this.range()))) {
                if (entity == this.player || !entity.isAlive()) continue;
                entity.addEffect(new MobEffectInstance(EidolonPotions.CHILLED_EFFECT, 30));
                if (!entity.canFreeze()) continue;
                entity.setTicksFrozen(entity.getTicksFrozen() + 80);
            }
        }
    }
}

