/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.entity;

import alexthw.eidolon_repraised.api.spells.Rune;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.api.spells.SignSequence;
import alexthw.eidolon_repraised.api.spells.Spell;
import alexthw.eidolon_repraised.client.particle.RuneParticleData;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.network.SpellCastPacket;
import alexthw.eidolon_repraised.registries.EidolonAttributes;
import alexthw.eidolon_repraised.registries.EidolonEntities;
import alexthw.eidolon_repraised.registries.EidolonSounds;
import alexthw.eidolon_repraised.registries.Runes;
import alexthw.eidolon_repraised.registries.Signs;
import alexthw.eidolon_repraised.registries.Spells;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChantCasterEntity
extends Entity
implements IEntityWithComplexSpawn {
    public static final EntityDataAccessor<CompoundTag> RUNES = SynchedEntityData.defineId(ChantCasterEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final EntityDataAccessor<CompoundTag> SIGNS = SynchedEntityData.defineId(ChantCasterEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final EntityDataAccessor<Integer> INDEX = SynchedEntityData.defineId(ChantCasterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Optional<UUID>> CASTER_ID = SynchedEntityData.defineId(ChantCasterEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Boolean> SUCCEEDED = SynchedEntityData.defineId(ChantCasterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int timer = 0;
    public int deathTimer = 0;
    public Vec3 look;
    @Nullable
    Player caster;

    public ChantCasterEntity(Level world, Player caster, List<Sign> runes, Vec3 look) {
        super((EntityType)EidolonEntities.CHANT_CASTER.get(), world);
        this.look = look;
        this.caster = caster;
        this.setChantTag(runes);
        this.getEntityData().set(CASTER_ID, Optional.of(caster.getUUID()));
    }

    public ChantCasterEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public static void createChanter(Player player, Level world, List<Sign> runes) {
        for (Sign rune : runes) {
            if (KnowledgeUtil.knowsSign(player, rune)) continue;
            return;
        }
        Vec3 placement = player.position().add(0.0, (double)(player.getBbHeight() * 2.0f / 3.0f), 0.0).add(player.getLookAngle().scale(0.5));
        ChantCasterEntity entity = new ChantCasterEntity(world, player, runes, player.getLookAngle());
        entity.setPos(placement.x, placement.y, placement.z);
        world.addFreshEntity((Entity)entity);
    }

    protected CompoundTag getNoRunesTag() {
        CompoundTag emptyRunes = new CompoundTag();
        emptyRunes.put("runes", (Tag)new ListTag());
        return emptyRunes;
    }

    protected List<Rune> loadRunesTag() {
        ArrayList<Rune> runes = new ArrayList<Rune>();
        ListTag runesTag = ((CompoundTag)this.getEntityData().get(RUNES)).getList("runes", 8);
        for (int i = 0; i < runesTag.size(); ++i) {
            Rune r = Runes.find(ResourceLocation.parse((String)runesTag.getString(i)));
            if (r == null) continue;
            runes.add(r);
        }
        return runes;
    }

    protected void setRunesTag(List<Rune> runes) {
        ListTag runesList = new ListTag();
        CompoundTag runesTag = new CompoundTag();
        for (Rune r : runes) {
            runesList.add((Object)StringTag.valueOf((String)r.getRegistryName().toString()));
        }
        runesTag.put("runes", (Tag)runesList);
        this.getEntityData().set(RUNES, (Object)runesTag);
    }

    protected List<Sign> loadChantTag() {
        ArrayList<Sign> runes = new ArrayList<Sign>();
        ListTag runesTag = ((CompoundTag)this.getEntityData().get(RUNES)).getList("runes", 8);
        for (int i = 0; i < runesTag.size(); ++i) {
            Sign r = Signs.find(ResourceLocation.tryParse((String)runesTag.getString(i)));
            if (r == null) continue;
            runes.add(r);
        }
        return runes;
    }

    protected void setChantTag(List<Sign> signs) {
        ListTag signList = new ListTag();
        CompoundTag signTag = new CompoundTag();
        for (Sign r : signs) {
            signList.add((Object)StringTag.valueOf((String)r.getRegistryName().toString()));
        }
        signTag.put("runes", (Tag)signList);
        this.getEntityData().set(RUNES, (Object)signTag);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        builder.define(RUNES, (Object)this.getNoRunesTag());
        builder.define(SIGNS, (Object)new SignSequence().serializeNbt());
        builder.define(INDEX, (Object)0);
        builder.define(CASTER_ID, Optional.empty());
        builder.define(SUCCEEDED, (Object)false);
    }

    public void tick() {
        double castSpeed;
        super.tick();
        if (this.deathTimer > 0) {
            --this.deathTimer;
            if (this.deathTimer <= 0) {
                this.remove(Entity.RemovalReason.KILLED);
            }
            return;
        }
        if (this.timer > 0) {
            --this.timer;
            if (this.timer <= 0) {
                CompoundTag signData = (CompoundTag)this.getEntityData().get(SIGNS);
                Optional optuuid = (Optional)this.getEntityData().get(CASTER_ID);
                if (!this.level().isClientSide && optuuid.isPresent()) {
                    SignSequence seq = SignSequence.deserializeNbt(signData);
                    Spell spell = Spells.find(seq, this.level());
                    Player player = this.level().getPlayerByUUID((UUID)optuuid.get());
                    if (spell != null && player != null && spell.canCast(this.level(), this.blockPosition(), player, seq)) {
                        spell.cast(this.level(), this.blockPosition(), player, seq);
                        Networking.sendToNearbyClient(this.level(), this.blockPosition(), (CustomPacketPayload)new SpellCastPacket(player, this.blockPosition(), spell, seq));
                        this.getEntityData().set(SUCCEEDED, (Object)true);
                    } else {
                        this.level().playSound(null, this.blockPosition(), SoundEvents.FIRE_EXTINGUISH, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        this.getEntityData().set(SUCCEEDED, (Object)false);
                    }
                }
                this.deathTimer = 20;
                return;
            }
        }
        this.cacheCaster();
        if (this.caster == null) {
            castSpeed = 1.0;
        } else {
            AttributeInstance attribute = this.caster.getAttribute(EidolonAttributes.CHANTING_SPEED);
            double d = castSpeed = attribute != null ? attribute.getValue() : 1.0;
        }
        if (this.timer <= 0 && this.tickCount % Mth.floor((double)(5.0 / castSpeed)) == 0) {
            List<Sign> runes = this.loadChantTag();
            SignSequence seq = SignSequence.deserializeNbt((CompoundTag)this.getEntityData().get(SIGNS));
            Vector3f initColor = seq.getAverageColor();
            int index = (Integer)this.getEntityData().get(INDEX);
            if (index >= runes.size()) {
                return;
            }
            Sign sign = runes.get(index);
            seq.addRight(sign);
            Vector3f afterColor = seq.getAverageColor();
            double x = this.getX() + 0.1 * this.random.nextGaussian();
            double y = this.getY() + 0.1 * this.random.nextGaussian();
            double z = this.getZ() + 0.1 * this.random.nextGaussian();
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)new RuneParticleData(Runes.find(ResourceLocation.tryParse((String)"eidolon_repraised:sin")), initColor.x(), initColor.y(), initColor.z(), afterColor.x(), afterColor.y(), afterColor.z()), x, y, z, this.look.x * 0.03, this.look.y * 0.03, this.look.z * 0.03);
            }
            this.level().playSound(null, this.blockPosition(), (SoundEvent)EidolonSounds.CHANT_WORD.get(), SoundSource.NEUTRAL, 0.7f, this.random.nextFloat() * 0.375f + 0.625f);
            if (index + 1 >= runes.size()) {
                Spell match = Spells.find(seq, this.level());
                int n = this.timer = match != null ? match.getDelay() : 10;
            }
            if (!this.level().isClientSide) {
                this.getEntityData().set(INDEX, (Object)(index + 1));
                this.getEntityData().set(SIGNS, (Object)seq.serializeNbt());
            }
        }
        if (this.caster != null) {
            double rad = Math.toRadians(this.caster.yHeadRot);
            this.setPos(this.caster.getEyePosition().add(-Math.sin(rad) / 2.0, -0.75, Math.cos(rad) / 2.0));
            this.look = this.caster.getLookAngle();
        }
    }

    private void cacheCaster() {
        Player e;
        Optional optuuid;
        if (this.caster == null && (optuuid = (Optional)this.getEntityData().get(CASTER_ID)).isPresent() && (e = this.level().getPlayerByUUID((UUID)optuuid.get())) != null) {
            this.caster = e;
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.getEntityData().set(RUNES, (Object)compound.getCompound("runes_tag"));
        this.getEntityData().set(SIGNS, (Object)compound.getCompound("signs_tag"));
        this.getEntityData().set(INDEX, (Object)compound.getInt("index"));
        this.getEntityData().set(CASTER_ID, Optional.of(compound.getUUID("caster_id")));
        this.look = new Vec3(compound.getDouble("lookX"), compound.getDouble("lookY"), compound.getDouble("lookZ"));
        this.timer = compound.getInt("timer");
        this.deathTimer = compound.getInt("deathTimer");
        this.getEntityData().set(SUCCEEDED, (Object)compound.getBoolean("succeeded"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.put("runes_tag", (Tag)this.getEntityData().get(RUNES));
        compound.put("signs_tag", (Tag)this.getEntityData().get(SIGNS));
        compound.putInt("index", ((Integer)this.getEntityData().get(INDEX)).intValue());
        compound.putInt("timer", this.timer);
        if (((Optional)this.getEntityData().get(CASTER_ID)).isPresent()) {
            compound.putUUID("caster_id", (UUID)((Optional)this.getEntityData().get(CASTER_ID)).get());
        }
        compound.putDouble("lookX", this.look.x);
        compound.putDouble("lookY", this.look.y);
        compound.putDouble("lookZ", this.look.z);
        compound.putInt("deathTimer", this.deathTimer);
        compound.putBoolean("succeeded", ((Boolean)this.getEntityData().get(SUCCEEDED)).booleanValue());
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeDouble(this.look.x);
        buffer.writeDouble(this.look.y);
        buffer.writeDouble(this.look.z);
    }

    public void readSpawnData(RegistryFriendlyByteBuf buf) {
        this.look = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }
}

