/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.block;

import alexthw.eidolon_repraised.common.block.BlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TableBlockBase
extends BlockBase
implements SimpleWaterloggedBlock {
    VoxelShape NORMAL = Shapes.box((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    VoxelShape CORNER = Shapes.joinUnoptimized((VoxelShape)this.NORMAL, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.OR);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty NX = BooleanProperty.create((String)"nx");
    public static final BooleanProperty PX = BooleanProperty.create((String)"px");
    public static final BooleanProperty NZ = BooleanProperty.create((String)"nz");
    public static final BooleanProperty PZ = BooleanProperty.create((String)"pz");

    public TableBlockBase(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)super.defaultBlockState().setValue((Property)NX, (Comparable)Boolean.valueOf(false))).setValue((Property)PX, (Comparable)Boolean.valueOf(false))).setValue((Property)NZ, (Comparable)Boolean.valueOf(false))).setValue((Property)PZ, (Comparable)Boolean.valueOf(false)));
    }

    public TableBlockBase setMainShape(VoxelShape shape) {
        this.NORMAL = shape;
        this.CORNER = Shapes.joinUnoptimized((VoxelShape)this.NORMAL, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return this;
    }

    @Override
    @NotNull
    public VoxelShape getInteractionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        boolean nx = (Boolean)state.getValue((Property)NX);
        boolean px = (Boolean)state.getValue((Property)PX);
        boolean nz = (Boolean)state.getValue((Property)NZ);
        boolean pz = (Boolean)state.getValue((Property)PZ);
        if (!nx && !nz || !nx && !pz || !px && !pz || !px && !nz) {
            return this.CORNER;
        }
        return this.NORMAL;
    }

    protected BlockState updateCorners(BlockGetter world, BlockPos pos, BlockState state) {
        BlockState blockstate = world.getBlockState(pos.north());
        BlockState blockstate1 = world.getBlockState(pos.east());
        BlockState blockstate2 = world.getBlockState(pos.south());
        BlockState blockstate3 = world.getBlockState(pos.west());
        boolean conn1 = blockstate.getBlock() == this;
        boolean conn2 = blockstate1.getBlock() == this;
        boolean conn3 = blockstate2.getBlock() == this;
        boolean conn4 = blockstate3.getBlock() == this;
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NZ, (Comparable)Boolean.valueOf(conn1))).setValue((Property)PX, (Comparable)Boolean.valueOf(conn2))).setValue((Property)PZ, (Comparable)Boolean.valueOf(conn3))).setValue((Property)NX, (Comparable)Boolean.valueOf(conn4));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level iblockreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        return (BlockState)this.updateCorners((BlockGetter)iblockreader, blockpos, super.getStateForPlacement(context)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return this.updateCorners((BlockGetter)world, pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NX, PX, NZ, PZ, WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }
}

