package alexthw.eidolon_repraised.gui;

import alexthw.eidolon_repraised.Eidolon;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(Dist.CLIENT)
public class WoodenBrewingStandScreen extends AbstractContainerScreen<WoodenBrewingStandContainer> {
    private static final ResourceLocation BREWING_STAND_GUI_TEXTURES = ResourceLocation.fromNamespaceAndPath(Eidolon.MODID,"textures/gui/wooden_brewing_stand.png" );
    private static final int[] BUBBLELENGTHS = new int[]{29, 24, 20, 16, 11, 6, 0};

    public WoodenBrewingStandScreen(WoodenBrewingStandContainer p_i51097_1_, Inventory p_i51097_2_, Component p_i51097_3_) {
        super(p_i51097_1_, p_i51097_2_, p_i51097_3_);
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width(this.title)) / 2;
    }

    public void render(@NotNull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrixStack, mouseX, mouseY);
    }

    protected void renderBg(@NotNull GuiGraphics matrixStack, float partialTicks, int x, int y) {
        matrixStack.setColor(1.0F, 1.0F, 1.0F, 1.0F);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        matrixStack.blit(BREWING_STAND_GUI_TEXTURES, i, j, 0, 0, this.imageWidth, this.imageHeight);
        if (menu.getHeat() > 0) {
            matrixStack.blit(BREWING_STAND_GUI_TEXTURES, i + 32, j + 52, 197, 0, 14, 14);
        }

        int i1 = this.menu.getTime();
        if (i1 > 0) {
            int j1 = (int) (28.0F * (1.0F - (float) i1 / 800));
            if (j1 > 0) {
                matrixStack.blit(BREWING_STAND_GUI_TEXTURES, i + 97, j + 16, 176, 0, 9, j1);
            }

            j1 = BUBBLELENGTHS[i1 / 2 % 7];
            if (j1 > 0) {
                matrixStack.blit(BREWING_STAND_GUI_TEXTURES, i + 63, j + 14 + 29 - j1, 185, 29 - j1, 12, j1);
            }
        }
    }
}

