/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.api.spells.Spell;
import alexthw.eidolon_repraised.common.spell.ExecCommandSpell;
import alexthw.eidolon_repraised.recipe.ChantRecipe;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class CommandChantRecipe
extends ChantRecipe {
    List<String> commands;
    int manaCost = 0;

    public CommandChantRecipe(ResourceLocation id, List<Sign> signs, List<String> commands, int manaCost) {
        super(id, signs);
        this.commands = commands;
        this.manaCost = manaCost;
    }

    public int manaCost() {
        return this.manaCost;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    @Override
    public Spell getChant() {
        return new ExecCommandSpell(this.id, this.manaCost, this.signs().toArray(new Sign[0]), this.getCommands());
    }

    @Override
    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.COMMAND_CHANT_TYPE.get();
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.COMMAND_CHANT_SERIALIZER.get();
    }

    @Override
    public JsonObject toJson() {
        JsonObject base = super.toJson();
        JsonArray commandsJson = new JsonArray();
        for (String command : this.commands) {
            commandsJson.add(command);
        }
        base.add("commands", (JsonElement)commandsJson);
        base.addProperty("mana_cost", (Number)this.manaCost);
        return base;
    }

    public static class Serializer
    implements RecipeSerializer<CommandChantRecipe> {
        public static final MapCodec<CommandChantRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ChantRecipe::getId), (App)Sign.CODEC.listOf().fieldOf("signs").forGetter(recipe -> recipe.signs), (App)Codec.STRING.listOf().fieldOf("commands").forGetter(CommandChantRecipe::getCommands), (App)Codec.INT.fieldOf("mana_cost").forGetter(CommandChantRecipe::manaCost)).apply((Applicative)instance, CommandChantRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CommandChantRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ChantRecipe::getId, (StreamCodec)Sign.STREAM_CODEC.apply(ByteBufCodecs.list()), ChantRecipe::signs, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), CommandChantRecipe::getCommands, (StreamCodec)ByteBufCodecs.INT, CommandChantRecipe::manaCost, CommandChantRecipe::new);

        @NotNull
        public MapCodec<CommandChantRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CommandChantRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

