/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.common.deity.Deities;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChantConversionRecipe
implements Recipe<RecipeInput> {
    public Ingredient input;
    ItemStack result;
    public float minDevotion;
    public float conversionCost;
    @Nullable
    public ResourceLocation deity;

    public ChantConversionRecipe(Ingredient input, ItemStack result, float minDevotion, float conversionCost, @Nullable ResourceLocation Deity2) {
        this.input = input;
        this.result = result;
        this.minDevotion = minDevotion;
        this.conversionCost = conversionCost;
        this.deity = Deity2;
    }

    public ChantConversionRecipe(Ingredient input, ItemStack result, float minDevotion, @Nullable ResourceLocation Deity2) {
        this(input, result, minDevotion, -1.0f, Deity2);
    }

    public boolean matches(@NotNull RecipeInput RecipeInput2, @NotNull Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.CHANT_CONVERSION_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.CHANT_CONVERSION_TYPE.get();
    }

    public JsonObject toJson() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "eidolon_repraised:chant_conversion");
        jsonobject.add("input", (JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.input).getOrThrow());
        jsonobject.addProperty("min_devotion", (Number)Float.valueOf(this.minDevotion));
        if (this.conversionCost >= 0.0f) {
            jsonobject.addProperty("conversion_cost", (Number)Float.valueOf(this.conversionCost));
        }
        if (this.deity != null) {
            jsonobject.addProperty("deity", this.deity.toString());
        }
        jsonobject.add("output", (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.result).getOrThrow());
        return jsonobject;
    }

    public static class Serializer
    implements RecipeSerializer<ChantConversionRecipe> {
        public static MapCodec<ChantConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)ItemStack.CODEC.fieldOf("output").forGetter(r -> r.result), (App)Codec.FLOAT.fieldOf("min_devotion").forGetter(r -> Float.valueOf(r.minDevotion)), (App)Codec.FLOAT.optionalFieldOf("conversion_cost", (Object)Float.valueOf(-1.0f)).forGetter(r -> Float.valueOf(r.conversionCost)), (App)ResourceLocation.CODEC.optionalFieldOf("deity", (Object)Deities.DUMMY_ID).forGetter(r -> r.deity)).apply((Applicative)c, ChantConversionRecipe::new));
        public static StreamCodec<RegistryFriendlyByteBuf, ChantConversionRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.input, (StreamCodec)ItemStack.STREAM_CODEC, r -> r.result, (StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(r.minDevotion), (StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(r.conversionCost), (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs::optional), r -> Optional.ofNullable(r.deity), (input, result, minDevotion, conversionCost, deity) -> new ChantConversionRecipe((Ingredient)input, (ItemStack)result, minDevotion.floatValue(), conversionCost.floatValue(), deity.orElse(null)));

        @NotNull
        public MapCodec<ChantConversionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ChantConversionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

