/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.datagen;

import alexthw.eidolon_repraised.datagen.EidAdvancementProvider;
import alexthw.eidolon_repraised.datagen.EidBiomeTagProvider;
import alexthw.eidolon_repraised.datagen.EidBlockStateProvider;
import alexthw.eidolon_repraised.datagen.EidBlockTagProvider;
import alexthw.eidolon_repraised.datagen.EidChantConversionProvider;
import alexthw.eidolon_repraised.datagen.EidChantProvider;
import alexthw.eidolon_repraised.datagen.EidDamageProvider;
import alexthw.eidolon_repraised.datagen.EidDataMapProvider;
import alexthw.eidolon_repraised.datagen.EidEnchantmentTagProvider;
import alexthw.eidolon_repraised.datagen.EidEntityTagProvider;
import alexthw.eidolon_repraised.datagen.EidForagingProvider;
import alexthw.eidolon_repraised.datagen.EidItemTagProvider;
import alexthw.eidolon_repraised.datagen.EidRecipeProvider;
import alexthw.eidolon_repraised.datagen.EidRitualProvider;
import alexthw.eidolon_repraised.datagen.EidWorldgenProvider;
import alexthw.eidolon_repraised.datagen.ModLootTables;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="eidolon_repraised", bus=EventBusSubscriber.Bus.MOD)
public class Datagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture provider = event.getLookupProvider();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeClient(), (DataProvider)new EidBlockStateProvider(gen, fileHelper));
        EidBlockTagProvider blockGen = new EidBlockTagProvider(gen, provider, fileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockGen);
        gen.addProvider(event.includeServer(), (DataProvider)new EidItemTagProvider(gen, provider, blockGen, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new EidDataMapProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLootTables(gen, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new EidRecipeProvider(gen, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new EidBiomeTagProvider(gen, provider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new EidWorldgenProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new EidDamageProvider.DamageTypeDataProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new EidDamageProvider.DamageTypeTagGen(output, provider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new EidRitualProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new EidChantProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new EidChantConversionProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new EidForagingProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new EidAdvancementProvider(gen, provider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new EidEnchantmentTagProvider(gen, provider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new EidEntityTagProvider(gen, provider, fileHelper));
    }
}

