/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.compat.apotheosis;

import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apothic_enchanting.asm.EnchHooks;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public class Apotheosis {
    private static final EquipmentSlot[] wandSlots = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND};

    public static int getMaxLevel(Enchantment enchantment) {
        return EnchHooks.getMaxLevel((Enchantment)enchantment);
    }

    public static int affixToAmount(AffixInstance affixInstance) {
        CodecProvider codecProvider = affixInstance.affix().get();
        if (codecProvider instanceof StepScalingAffix) {
            StepScalingAffix scalingAffix = (StepScalingAffix)codecProvider;
            return (int)scalingAffix.affixToAmount(affixInstance);
        }
        return 0;
    }

    public static void initialize() {
    }

    public static Pair<Integer, Integer> handleWandAffix(ItemStack stack) {
        int projectileAmount = 1;
        int trackingAmount = 0;
        Map affixes = AffixHelper.getAffixes((ItemStack)stack);
        return Pair.of((Object)projectileAmount, (Object)trackingAmount);
    }

    public static interface StepScalingAffix {
        @NotNull
        public Map<LootRarity, StepFunction> getValues();

        default public float affixToAmount(LootRarity rarity, float level) {
            return this.getValues().get(rarity).get(level);
        }

        default public float affixToAmount(AffixInstance affixInstance) {
            return this.affixToAmount((LootRarity)affixInstance.rarity().get(), affixInstance.level());
        }
    }
}

