/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.api.altar.AltarInfo;
import alexthw.eidolon_repraised.api.capability.IMana;
import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.common.deity.Deities;
import alexthw.eidolon_repraised.common.deity.DeityLocks;
import alexthw.eidolon_repraised.common.spell.PrayerSpell;
import alexthw.eidolon_repraised.common.tile.EffigyTileEntity;
import alexthw.eidolon_repraised.registries.AdvancementTriggers;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.Registry;
import alexthw.eidolon_repraised.registries.Signs;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ConvertZombieSpell
extends PrayerSpell {
    public ConvertZombieSpell(ResourceLocation resourceLocation, int baseRep, double powerMult, Sign ... signs) {
        super(resourceLocation, Deities.LIGHT_DEITY, 20, baseRep, powerMult, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        EntityHitResult result;
        HitResult ray = ConvertZombieSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
        boolean flag = ray instanceof EntityHitResult && (result = (EntityHitResult)ray).getEntity() instanceof ZombieVillager;
        EffigyTileEntity effigy = ConvertZombieSpell.getEffigy(world, pos);
        if (effigy == null) {
            player.displayClientMessage((Component)Component.translatable((String)"eidolon_repraised.message.no_effigy"), true);
            return false;
        }
        AltarInfo info = AltarInfo.getAltarInfo(world, effigy.getBlockPos());
        if (info.getAltar() != Registry.STONE_ALTAR.get() || info.getIcon() != Registry.ELDER_EFFIGY.get()) {
            return false;
        }
        return flag && super.canCast(world, pos, player);
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        EntityHitResult result;
        Entity entity;
        EffigyTileEntity effigy = ConvertZombieSpell.getEffigy(world, pos);
        if (effigy == null) {
            return;
        }
        HitResult ray = ConvertZombieSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
        if (!(ray instanceof EntityHitResult) || !((entity = (result = (EntityHitResult)ray).getEntity()) instanceof ZombieVillager)) {
            return;
        }
        ZombieVillager villager = (ZombieVillager)entity;
        if (world instanceof ServerLevel && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            effigy.pray();
            AltarInfo info = AltarInfo.getAltarInfo(world, effigy.getBlockPos());
            IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
            if (reputation != null) {
                reputation.pray(this, world.getGameTime());
                ((PlayerTrigger)AdvancementTriggers.CURE_ZOMBIE.get()).trigger(serverPlayer);
                KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.CURE_ZOMBIE);
                reputation.addReputation(this.deity.getId(), (double)this.getBaseRep() + this.getPowerMultiplier() * info.getPower());
                ConvertZombieSpell.updateMagic(info, player, world, reputation.getReputation(this.deity.getId()));
            }
            villager.startConverting(player.getUUID(), 20);
            IMana.expendMana(player, this.getCost());
        } else {
            this.playSuccessSound(world, player, effigy, Signs.HARMONY_SIGN);
        }
    }
}

