/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.registries.EidolonRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WorktableRecipe
implements Recipe<CraftingInput> {
    public final ShapedRecipePattern pattern_core;
    public final ShapedRecipePattern pattern_outer;
    final ItemStack result;

    public WorktableRecipe(ShapedRecipePattern core, ShapedRecipePattern outer, ItemStack result) {
        this.pattern_core = core;
        this.pattern_outer = outer;
        this.result = result;
    }

    public List<Ingredient> getCore() {
        return this.pattern_core.ingredients();
    }

    public List<Ingredient> getOuter() {
        return this.pattern_outer.ingredients();
    }

    public boolean matches(CraftingContainer coreInv, CraftingContainer extraInv) {
        if (coreInv.getContainerSize() < 9 || extraInv.getContainerSize() < 4 || this.pattern_core == null) {
            return false;
        }
        return this.pattern_core.matches(coreInv.asCraftInput()) && this.pattern_outer.matches(extraInv.asCraftInput());
    }

    public NonNullList<ItemStack> getRemainingItems(Container coreInv, Container extraInv) {
        NonNullList items = NonNullList.withSize((int)13, (Object)ItemStack.EMPTY);
        for (int i = 0; i < items.size(); ++i) {
            Container inv = i < 9 ? coreInv : extraInv;
            ItemStack item = inv.getItem(i < 9 ? i : i - 9);
            if (!item.hasCraftingRemainingItem()) continue;
            items.set(i, (Object)item.getCraftingRemainingItem());
        }
        return items;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.addAll(this.getCore());
        ingredients.addAll(this.getOuter());
        return ingredients;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level worldIn) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.getResultItem(registries);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.WORKTABLE_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.WORKTABLE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<WorktableRecipe> {
        static int maxWidth = 4;
        static int maxHeight = 1;
        public static final Codec<List<String>> R_PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(p_312085_ -> {
            if (p_312085_.size() > maxHeight) {
                return DataResult.error(() -> "Invalid pattern: too many rows, %s is maximum".formatted(maxHeight));
            }
            if (p_312085_.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)p_312085_.getFirst()).length();
            for (String s : p_312085_) {
                if (s.length() > maxWidth) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, %s is maximum".formatted(maxWidth));
                }
                if (i == s.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)p_312085_);
        }, Function.identity());
        public static final MapCodec<ShapedRecipePattern.Data> REAGENT_MAP_CODEC = RecordCodecBuilder.mapCodec(p_312573_ -> p_312573_.group((App)ExtraCodecs.strictUnboundedMap((Codec)ShapedRecipePattern.Data.SYMBOL_CODEC, (Codec)Ingredient.CODEC_NONEMPTY).fieldOf("key").forGetter(ShapedRecipePattern.Data::key), (App)R_PATTERN_CODEC.fieldOf("reagents").forGetter(ShapedRecipePattern.Data::pattern)).apply((Applicative)p_312573_, ShapedRecipePattern.Data::new));
        public static final MapCodec<ShapedRecipePattern> PATTERN_CORE_CODEC = ShapedRecipePattern.Data.MAP_CODEC.flatXmap(data -> Serializer.unpack(data, false), p_344423_ -> p_344423_.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
        public static final MapCodec<ShapedRecipePattern> PATTERN_OUTER_CODEC = REAGENT_MAP_CODEC.flatXmap(data -> Serializer.unpack(data, true), p_344423_ -> p_344423_.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
        public static final MapCodec<WorktableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PATTERN_CORE_CODEC.forGetter(r -> r.pattern_core), (App)PATTERN_OUTER_CODEC.forGetter(r -> r.pattern_outer), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result)).apply((Applicative)instance, WorktableRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WorktableRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ShapedRecipePattern.STREAM_CODEC, r -> r.pattern_core, (StreamCodec)ShapedRecipePattern.STREAM_CODEC, r -> r.pattern_outer, (StreamCodec)ItemStack.STREAM_CODEC, WorktableRecipe::getResult, WorktableRecipe::new);

        @NotNull
        public MapCodec<WorktableRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, WorktableRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static DataResult<ShapedRecipePattern> unpack(ShapedRecipePattern.Data data, boolean isOuter) {
            String[] astring = ShapedRecipePattern.shrink((List)data.pattern());
            int i = isOuter ? 4 : astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = NonNullList.withSize((int)(i * j), (Object)Ingredient.EMPTY);
            CharArraySet charset = new CharArraySet(data.key().keySet());
            for (int k = 0; k < astring.length; ++k) {
                String s = astring[k];
                for (int l = 0; l < s.length(); ++l) {
                    Ingredient ingredient;
                    char c0 = s.charAt(l);
                    Ingredient ingredient2 = ingredient = c0 == ' ' ? Ingredient.EMPTY : (Ingredient)data.key().get(Character.valueOf(c0));
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + c0 + "' but it's not defined in the key");
                    }
                    charset.remove(c0);
                    nonnulllist.set(l + i * k, (Object)ingredient);
                }
            }
            return DataResult.success((Object)new ShapedRecipePattern(i, j, nonnulllist, Optional.of(data)));
        }
    }
}

