/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.network;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.capability.WingsDataImpl;
import alexthw.eidolon_repraised.network.AbstractPacket;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WingsDashPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<WingsDashPacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("wings_dash"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WingsDashPacket> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, pkt -> pkt.uuid, WingsDashPacket::new);
    final UUID uuid;

    public WingsDashPacket(Player player) {
        this.uuid = player.getUUID();
    }

    public WingsDashPacket(UUID uuid) {
        this.uuid = uuid;
    }

    public static void encode(WingsDashPacket object, FriendlyByteBuf buffer) {
        buffer.writeUUID(object.uuid);
    }

    public static WingsDashPacket decode(FriendlyByteBuf buffer) {
        return new WingsDashPacket(buffer.readUUID());
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        WingsDataImpl wing;
        if (player.getUUID().equals(this.uuid) && (wing = (WingsDataImpl)player.getCapability(EidolonCapabilities.WINGS_CAPABILITY)) != null) {
            wing.tryDash((Player)player);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

