/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.block;

import alexthw.eidolon_repraised.common.tile.TileEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SingleItemTile
extends TileEntityBase
implements Container {
    protected ItemStack stack = ItemStack.EMPTY;

    public SingleItemTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int pSlot) {
        return this.stack;
    }

    @NotNull
    public ItemStack removeItem(int pSlot, int pAmount) {
        ItemStack copyStack = this.stack.copy().split(pAmount);
        this.stack.shrink(pAmount);
        this.sync();
        return copyStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int pSlot) {
        ItemStack stack = this.stack.copy();
        this.stack = ItemStack.EMPTY;
        this.sync();
        return stack;
    }

    public void setItem(int pSlot, @NotNull ItemStack pStack) {
        this.stack = pStack;
        this.sync();
    }

    public boolean canPlaceItem(int pIndex, @NotNull ItemStack pStack) {
        return this.stack.isEmpty();
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return false;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public void clearContent() {
        this.stack = ItemStack.EMPTY;
        this.sync();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack otherStack) {
        this.stack = otherStack;
        this.sync();
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("stack"));
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.stack != null) {
            tag.put("stack", this.stack.saveOptional(registries));
        }
    }
}

