/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.api.spells;

import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.registries.Signs;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class SignSequence {
    public final ArrayDeque<Sign> seq = new ArrayDeque();
    public Sign last = null;

    public SignSequence() {
    }

    public SignSequence(Collection<Sign> signs) {
        this.seq.addAll(signs);
    }

    public SignSequence(Sign ... signs) {
        for (Sign s : signs) {
            this.seq.addLast(s);
        }
    }

    public void addLeft(Sign s) {
        this.seq.addFirst(s);
    }

    public void addRight(Sign s) {
        this.seq.addLast(s);
    }

    public Sign[] toArray() {
        return (Sign[])this.seq.toArray(Sign[]::new);
    }

    public void removeLeft() {
        this.last = this.seq.getFirst();
        this.seq.removeFirst();
    }

    public void removeRight() {
        this.last = this.seq.getLast();
        this.seq.removeLast();
    }

    private int count(Sign s) {
        int count = 0;
        for (Sign sign : this.seq) {
            if (!s.equals(sign)) continue;
            ++count;
        }
        return count;
    }

    private boolean contains(Sign s) {
        for (Sign sign : this.seq) {
            if (!s.equals(sign)) continue;
            return true;
        }
        return false;
    }

    private boolean containsN(Sign s, int n) {
        Iterator<Sign> iterator = this.seq.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            if (s.equals(iterator.next())) {
                ++count;
            }
            if (count < n) continue;
            return true;
        }
        return false;
    }

    public boolean removeLeftmost(Sign s) {
        if (!this.seq.contains(s)) {
            return false;
        }
        this.last = s;
        this.seq.removeFirstOccurrence(s);
        return true;
    }

    public boolean removeRightmost(Sign s) {
        if (!this.seq.contains(s)) {
            return false;
        }
        this.last = s;
        this.seq.removeLastOccurrence(s);
        return true;
    }

    public int removeAll(Sign s) {
        int count = this.count(s);
        if (this.seq.contains(s)) {
            this.last = s;
        }
        this.seq.removeIf(i -> i.equals(s));
        return count;
    }

    public boolean removeLeftmostN(Sign s, int n) {
        if (n == 0) {
            return true;
        }
        if (!this.containsN(s, n)) {
            return false;
        }
        this.last = s;
        for (int i = 0; i < n; ++i) {
            this.seq.removeFirstOccurrence(s);
        }
        return true;
    }

    public boolean removeRightmostN(Sign s, int n) {
        if (n == 0) {
            return true;
        }
        if (!this.containsN(s, n)) {
            return false;
        }
        this.last = s;
        for (int i = 0; i < n; ++i) {
            this.seq.removeLastOccurrence(s);
        }
        return true;
    }

    public void map(Function<Sign, Sign> tf) {
        int n = this.seq.size();
        for (int i = 0; i < n; ++i) {
            this.seq.addLast(tf.apply(this.seq.getFirst()));
        }
    }

    @Nullable
    public Sign getLast() {
        return this.last;
    }

    public CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Sign s : this.seq) {
            list.add((Object)StringTag.valueOf((String)s.key().toString()));
        }
        tag.put("seq", (Tag)list);
        if (this.last != null) {
            tag.putString("last", this.last.getRegistryName().toString());
        }
        return tag;
    }

    public static SignSequence deserializeNbt(CompoundTag tag) {
        SignSequence s = new SignSequence();
        ListTag list = tag.getList("seq", 8);
        for (int i = 0; i < list.size(); ++i) {
            Sign t = Signs.find(ResourceLocation.parse((String)list.getString(i)));
            if (t == null) continue;
            s.seq.addLast(t);
        }
        s.last = tag.contains("last") ? Signs.find(ResourceLocation.parse((String)tag.getString("last"))) : null;
        return s;
    }

    public Vector3f getAverageColor() {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        for (Sign s : this.seq) {
            r += s.getRed();
            g += s.getGreen();
            b += s.getBlue();
        }
        return new Vector3f(r /= (float)(this.seq.size() + 1), g /= (float)(this.seq.size() + 1), b /= (float)(this.seq.size() + 1));
    }

    public boolean equals(Object other) {
        if (other instanceof SignSequence) {
            SignSequence s = (SignSequence)other;
            if (s.seq.size() != this.seq.size()) {
                return false;
            }
            Iterator<Sign> a = this.seq.iterator();
            Iterator<Sign> b = s.seq.iterator();
            while (a.hasNext() && b.hasNext()) {
                Sign sb;
                Sign sa = a.next();
                if (sa.equals(sb = b.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

