/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.registries.EidolonRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ForagingRecipe
implements Recipe<CraftingInput> {
    public ResourceLocation id;
    public ItemStack result;
    public Ingredient block;

    public ForagingRecipe(ResourceLocation id, ItemStack output, Ingredient block) {
        this.id = id;
        this.result = output;
        this.block = block;
    }

    public ForagingRecipe(ItemStack output, Ingredient block) {
        this.result = output;
        this.block = block;
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.FORAGING_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.FORAGING_TYPE.get();
    }

    public JsonObject toJson() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "eidolon_repraised:athame_foraging");
        jsonobject.add("block", (JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.block).getOrThrow());
        jsonobject.add("output", (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.result).getOrThrow());
        return jsonobject;
    }

    public static class Serializer
    implements RecipeSerializer<ForagingRecipe> {
        public static final MapCodec<ForagingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("output").forGetter(r -> r.result), (App)Ingredient.CODEC.fieldOf("block").forGetter(r -> r.block)).apply((Applicative)instance, ForagingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ForagingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, r -> r.result, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.block, ForagingRecipe::new);

        @NotNull
        public MapCodec<ForagingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ForagingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

