/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client.model;

import alexthw.eidolon_repraised.common.entity.RavenEntity;
import alexthw.eidolon_repraised.util.ClientInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RavenModel
extends EntityModel<RavenEntity> {
    private final ModelPart body;

    public RavenModel(ModelPart root) {
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)-0.5f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -3.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-0.5f, -2.0f, -5.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-1.5f));
        PartDefinition wings = body.addOrReplaceChild("wings", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, -3.5f, -0.5f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tailMid = body.addOrReplaceChild("tailMid", CubeListBuilder.create().texOffs(13, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)3.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftTail = body.addOrReplaceChild("leftTail", CubeListBuilder.create().texOffs(16, 14).mirror().addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.75f, (float)-3.0f, (float)2.5f, (float)-0.2618f, (float)0.2618f, (float)0.0f));
        PartDefinition rightTail = body.addOrReplaceChild("rightTail", CubeListBuilder.create().texOffs(16, 14).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.75f, (float)-3.0f, (float)2.5f, (float)-0.2618f, (float)-0.2618f, (float)0.0f));
        PartDefinition leftWing = body.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(0, 25).addBox(0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-5.5f, (float)-1.5f));
        PartDefinition rightWing = body.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(0, 25).mirror().addBox(-10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.0f, (float)-5.5f, (float)-1.5f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(12, 7).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-3.0f, (float)0.5f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(12, 7).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-3.0f, (float)0.5f));
        PartDefinition chest = body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(1, 6).addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderOnShoulder(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float p_228284_5_, float p_228284_6_, float p_228284_7_, float p_228284_8_, int p_228284_9_) {
        this.body.getChild((String)"leftWing").visible = false;
        this.body.getChild((String)"rightWing").visible = false;
        this.body.getChild((String)"wings").visible = true;
        this.body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void setupAnim(RavenEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart leftWing = this.body.getChild("leftWing");
        ModelPart rightWing = this.body.getChild("rightWing");
        ModelPart wings = this.body.getChild("wings");
        ModelPart rightLeg = this.body.getChild("rightLeg");
        ModelPart leftLeg = this.body.getChild("leftLeg");
        ModelPart head = this.body.getChild("head");
        this.body.y = 24.0f;
        if (entity.onGround() || !entity.isAddedToLevel()) {
            leftWing.visible = false;
            rightWing.visible = false;
            wings.visible = true;
            if (entity.isTame() && entity.isInSittingPose()) {
                rightLeg.xRot = -1.0471976f;
                leftLeg.xRot = -1.0471976f;
                this.body.y = 25.5f;
            } else {
                rightLeg.xRot = Mth.cos((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
                leftLeg.xRot = Mth.cos((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
            }
        } else {
            leftWing.visible = true;
            rightWing.visible = true;
            wings.visible = false;
            rightLeg.xRot = 0.0f;
            leftLeg.xRot = 0.0f;
            if (entity.getDeltaMovement().y < 0.0) {
                rightWing.zRot = Mth.sin((float)ClientInfo.getClientPartialTicks()) * 0.1f;
                leftWing.zRot = -Mth.sin((float)(0.97f + ClientInfo.getClientPartialTicks())) * 0.1f;
            } else {
                rightWing.zRot = (float)Math.sin(ClientInfo.getClientPartialTicks()) * 0.4f;
                leftWing.zRot = -((float)Math.sin(ClientInfo.getClientPartialTicks())) * 0.4f;
            }
        }
        head.xRot = (float)Math.toRadians(headPitch);
        head.yRot = (float)Math.toRadians(netHeadYaw);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

