/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.api.spells.SignSequence;
import alexthw.eidolon_repraised.api.spells.Spell;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import alexthw.eidolon_repraised.registries.Signs;
import alexthw.eidolon_repraised.registries.Spells;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ChantRecipe
implements Recipe<RecipeInput> {
    ResourceLocation id;
    List<Sign> signs;

    public ChantRecipe(ResourceLocation id, List<Sign> signs) {
        this.id = id;
        this.signs = signs;
    }

    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, @NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.CHANT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.CHANT_TYPE.get();
    }

    public Spell getChant() {
        return Spells.find(this.id);
    }

    public boolean matches(@NotNull SignSequence signs) {
        return signs.equals(new SignSequence(this.signs));
    }

    public List<Sign> signs() {
        return this.signs;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType().toString());
        json.addProperty("id", this.id.toString());
        JsonArray signsArray = new JsonArray();
        for (Sign sign : this.signs) {
            JsonObject signObj = new JsonObject();
            signObj.addProperty("sign", sign.getRegistryName().toString());
            signsArray.add((JsonElement)signObj);
        }
        json.add("signs", (JsonElement)signsArray);
        return json;
    }

    public static class Serializer
    implements RecipeSerializer<ChantRecipe> {
        public static final MapCodec<ChantRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ChantRecipe::getId), (App)Sign.CODEC.listOf().fieldOf("signs").forGetter(recipe -> recipe.signs)).apply((Applicative)instance, ChantRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ChantRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ChantRecipe::getId, (StreamCodec)Sign.STREAM_CODEC.apply(ByteBufCodecs.list()), ChantRecipe::signs, ChantRecipe::new);

        @NotNull
        public ChantRecipe fromJson(@NotNull ResourceLocation resourceLocation, @NotNull JsonObject jsonObject) {
            JsonArray signsArray = jsonObject.getAsJsonArray("signs");
            ArrayList<Sign> signs = new ArrayList<Sign>();
            for (JsonElement sign : signsArray) {
                signs.add(Signs.find(ResourceLocation.parse((String)sign.getAsString())));
            }
            return new ChantRecipe(resourceLocation, signs);
        }

        @NotNull
        public MapCodec<ChantRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ChantRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

