/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.network;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.client.particle.Particles;
import alexthw.eidolon_repraised.network.AbstractPacket;
import alexthw.eidolon_repraised.registries.EidolonParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FeatherEffectPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<FeatherEffectPacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("feather_effect"));
    public static final StreamCodec<FriendlyByteBuf, FeatherEffectPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, p -> Float.valueOf(p.x), (StreamCodec)ByteBufCodecs.FLOAT, p -> Float.valueOf(p.y), (StreamCodec)ByteBufCodecs.FLOAT, p -> Float.valueOf(p.z), FeatherEffectPacket::new);
    final float x;
    final float y;
    final float z;

    public FeatherEffectPacket(BlockPos pos) {
        this((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
    }

    public FeatherEffectPacket(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public static void encode(FeatherEffectPacket object, FriendlyByteBuf buffer) {
        buffer.writeFloat(object.x).writeFloat(object.y).writeFloat(object.z);
    }

    public static FeatherEffectPacket decode(FriendlyByteBuf buffer) {
        return new FeatherEffectPacket(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Level world = player.level();
        double x = this.x;
        double y = (double)this.y + 0.5;
        double z = this.z;
        Particles.create((ParticleType)EidolonParticles.FEATHER_PARTICLE.get()).setAlpha(0.5f, 0.0f).setScale(0.5f, 0.0f).setLifetime(20).randomOffset(0.125, 0.125).randomVelocity(0.0625).setColor(0.2f, 0.2f, 0.7f).repeat(world, x, y, z, 6);
        Particles.create((ParticleType)EidolonParticles.FEATHER_PARTICLE.get()).setAlpha(0.25f, 0.0f).setScale(0.5f, 0.0f).setLifetime(10).randomOffset(0.125, 0.125).randomVelocity(0.0625).setColor(0.3f, 0.3f, 0.7f).repeat(world, x + 0.5, y, z + 0.5, 6);
        Particles.create((ParticleType)EidolonParticles.FEATHER_PARTICLE.get()).setAlpha(0.5f, 0.0f).setScale(0.5f, 0.0f).setLifetime(10).randomOffset(0.125, 0.125).randomVelocity(0.0625).setColor(0.3f, 0.3f, 0.7f).repeat(world, x - 0.5, y, z - 0.5, 6);
        Particles.create((ParticleType)EidolonParticles.SPARKLE_PARTICLE.get()).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(80).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.125).addVelocity(0.0, 0.25, 0.0).setColor(0.2f, 0.2f, 0.7f).enableGravity().setSpin(0.4f).repeat(world, x, y, z, world.random.nextInt(4) + 3);
        Particles.create((ParticleType)EidolonParticles.SMOKE_PARTICLE.get()).setAlpha(0.25f, 0.0f).setScale(0.375f, 0.0f).setLifetime(20).randomOffset(0.25, 0.25).randomVelocity(0.015625, 0.015625).setColor(0.2f, 0.2f, 0.7f).repeat(world, x, y, z, 6);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

