/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.tile;

import alexthw.eidolon_repraised.api.ritual.IncenseRitual;
import alexthw.eidolon_repraised.common.tile.ContainerTileBase;
import alexthw.eidolon_repraised.common.tile.IBurner;
import alexthw.eidolon_repraised.registries.IncenseRegistry;
import alexthw.eidolon_repraised.registries.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class CenserTileEntity
extends ContainerTileBase
implements IBurner {
    boolean isBurning;
    int burnCounter;
    IncenseRitual incenseRitual;

    public CenserTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public CenserTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)Registry.CENSER_TILE_ENTITY.get(), pos, state);
    }

    @Override
    public boolean canStartBurning() {
        return !this.isBurning && !this.stack.isEmpty();
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        super.onDestroyed(state, pos);
        if (!this.isBurning && !this.stack.isEmpty() && this.level != null) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.stack));
        }
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide && this.isBurning && this.incense() != null) {
            ++this.burnCounter;
            this.incense().tick(this.burnCounter);
            this.sync();
        }
        if (this.burnCounter == 80) {
            this.stack = ItemStack.EMPTY;
            this.sync();
        }
        if (this.level.isClientSide && this.isBurning && this.incense() != null) {
            this.incenseRitual.animateParticles(this, this.burnCounter);
        }
    }

    @Override
    public ItemInteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.level instanceof ServerLevel && !this.isBurning) {
            ItemStack itemInHand = player.getItemInHand(hand);
            if (itemInHand.isEmpty() && !this.stack.isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack);
                this.stack = ItemStack.EMPTY;
                if (!this.level.isClientSide) {
                    this.sync();
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (!itemInHand.isEmpty() && this.stack.isEmpty()) {
                if (IncenseRegistry.getIncenseRitual(itemInHand.getItem()) != null) {
                    this.stack = itemInHand.split(1);
                    if (!this.level.isClientSide) {
                        this.sync();
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (!itemInHand.isEmpty() && !this.stack.isEmpty()) {
                if (itemInHand.getItem() instanceof FlintAndSteelItem && !this.level.isClientSide && this.canStartBurning()) {
                    this.startBurning(player, this.level, pos);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void startBurning(Player player, @NotNull Level world, BlockPos pos) {
        if (this.incense() != null && this.incense().start(player, this)) {
            this.isBurning = true;
            world.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(this.isBurning)));
            this.burnCounter = 0;
            this.sync();
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(pTag, provider);
        this.stack = pTag.contains("incense") ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)pTag.getCompound("incense")) : ItemStack.EMPTY;
        if (pTag.contains("incenseContext") && this.stack.isEmpty()) {
            this.incenseRitual = IncenseRitual.read(pTag);
            this.incenseRitual.start(null, this);
        }
        this.burnCounter = pTag.getInt("burnCounter");
        this.isBurning = pTag.getBoolean("isBurning");
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        if (!this.stack.isEmpty()) {
            pTag.put("incense", this.stack.saveOptional(provider));
        }
        if (this.incenseRitual != null) {
            this.incenseRitual.write(pTag);
        }
        pTag.putInt("burnCounter", this.burnCounter);
        pTag.putBoolean("isBurning", this.isBurning);
    }

    @Override
    public void extinguish() {
        if (this.level instanceof ServerLevel) {
            this.isBurning = false;
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(this.isBurning)));
            this.burnCounter = 0;
            this.incenseRitual = null;
            this.sync();
        }
    }

    public IncenseRitual incense() {
        if (this.incenseRitual == null && !this.stack.isEmpty()) {
            this.incenseRitual = IncenseRegistry.getIncenseRitual(this.stack.getItem());
        }
        return this.incenseRitual;
    }
}

