/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.incense;

import alexthw.eidolon_repraised.api.ritual.IncenseRitual;
import alexthw.eidolon_repraised.client.particle.Particles;
import alexthw.eidolon_repraised.registries.EidolonParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class RestorationIncense
extends IncenseRitual {
    public RestorationIncense(ResourceLocation registryName) {
        super(800, registryName);
    }

    @Override
    public float getGreen() {
        return 0.75f;
    }

    @Override
    public void tickEffect(int age) {
        if (age % 20 == 0) {
            Level level = this.censer.getLevel();
            BlockPos pos = this.censer.getBlockPos();
            assert (level != null);
            for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate((double)this.range()))) {
                if (entity.getType().is(EntityTypeTags.UNDEAD)) {
                    entity.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 1));
                    continue;
                }
                entity.heal(1.0f);
            }
        }
    }

    @Override
    public void animateParticles(int burnCounter, BlockPos blockPos, Level level) {
        super.animateParticles(burnCounter, blockPos, level);
        double x = blockPos.getX();
        double y = blockPos.getY() + 1;
        double z = blockPos.getZ();
        if (level.random.nextInt(5) == 0) {
            Particles.create((ParticleType)EidolonParticles.SMOKE_PARTICLE.get()).setAlpha(0.25f, 0.0f).setScale(0.375f, 0.125f).setLifetime(160).randomOffset((double)this.range() * 0.5, 0.125).randomVelocity(0.025f, 0.025f).addVelocity(0.0, 0.0125f, 0.0).setColor(0.75f, 0.5f, 0.5f, 0.25f, 0.25f, 0.25f).spawn(level, x, y + 0.125, z);
        }
        if (level.random.nextInt(8) == 0) {
            for (int i = 0; i < 3; ++i) {
                Particles.spawnParticle(level, (ParticleOptions)ParticleTypes.HEART, x, y - 0.5, z, 0.0, -0.01, 0.0, this.range(), 0.0, this.range());
            }
        }
    }
}

