/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client.renderer;

import alexthw.eidolon_repraised.client.ClientRegistry;
import alexthw.eidolon_repraised.client.model.RavenModel;
import alexthw.eidolon_repraised.client.renderer.RavenRenderer;
import alexthw.eidolon_repraised.registries.EidolonEntities;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class RavenVariantLayer<T extends Player>
extends RenderLayer<T, PlayerModel<T>> {
    private RavenModel model = null;

    public RavenVariantLayer(RenderLayerParent<T, PlayerModel<T>> rendererIn) {
        super(rendererIn);
    }

    public void render(@NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, @NotNull T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderRaven(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, netHeadYaw, headPitch, true);
        this.renderRaven(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, netHeadYaw, headPitch, false);
    }

    private void renderRaven(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, boolean leftShoulderIn) {
        if (this.model == null) {
            this.model = new RavenModel(Minecraft.getInstance().getEntityModels().bakeLayer(ClientRegistry.RAVEN_LAYER));
        }
        CompoundTag compoundnbt = leftShoulderIn ? entitylivingbaseIn.getShoulderEntityLeft() : entitylivingbaseIn.getShoulderEntityRight();
        EntityType.byString((String)compoundnbt.getString("id")).filter(p_215344_0_ -> p_215344_0_ == EidolonEntities.RAVEN.get()).ifPresent(p_229137_11_ -> {
            matrixStackIn.pushPose();
            matrixStackIn.translate(leftShoulderIn ? (double)0.4f : (double)-0.4f, entitylivingbaseIn.isCrouching() ? (double)-1.3f : -1.5, 0.0);
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(this.model.renderType(RavenRenderer.TEXTURE));
            this.model.renderOnShoulder(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, limbSwing, limbSwingAmount, netHeadYaw, headPitch, entitylivingbaseIn.tickCount);
            matrixStackIn.popPose();
        });
    }
}

