/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.ritual;

import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.network.CrystallizeEffectPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.util.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class LocationRitual
extends Ritual {
    TagKey<Structure> structureTagKey;
    public static final ResourceLocation SYMBOL = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"particle/summon_ritual");

    public LocationRitual(TagKey<Structure> structureTagKey) {
        super(SYMBOL, ColorUtil.packColor(255, 121, 94, 255));
        this.structureTagKey = structureTagKey;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"eidolon_repraised.ritual.location", (Object[])new Object[]{this.structureTagKey.location().getPath()});
    }

    @Override
    public Ritual cloneRitual() {
        return new LocationRitual(this.structureTagKey);
    }

    @Override
    public Ritual.RitualResult start(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            Networking.sendToNearbyClient((Level)world, pos, (CustomPacketPayload)new CrystallizeEffectPacket(pos));
            BlockPos structure = world.findNearestMapStructure(this.structureTagKey, pos, 100, true);
            if (structure != null) {
                ItemStack mapStack = MapItem.create((Level)world, (int)structure.getX(), (int)structure.getZ(), (byte)2, (boolean)true, (boolean)true);
                MapItem.renderBiomePreviewMap((ServerLevel)world, (ItemStack)mapStack);
                MapItemSavedData.addTargetDecoration((ItemStack)mapStack, (BlockPos)structure, (String)"+", (Holder)MapDecorationTypes.RED_X);
                mapStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Magic Map"));
                world.addFreshEntity((Entity)new ItemEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, mapStack));
            }
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

