/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.ritual;

import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.common.entity.ai.GoToPositionGoal;
import alexthw.eidolon_repraised.util.ColorUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class AllureRitual
extends Ritual {
    public static final ResourceLocation SYMBOL = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"particle/allure_ritual");

    public AllureRitual() {
        super(SYMBOL, ColorUtil.packColor(255, 255, 43, 75));
    }

    @Override
    public Ritual cloneRitual() {
        return new AllureRitual();
    }

    @Override
    public Ritual.RitualResult tick(Level world, BlockPos pos) {
        if (world.getGameTime() % 200L == 0L) {
            List animals = world.getEntitiesOfClass(Animal.class, new AABB(pos).inflate(96.0, 16.0, 96.0));
            for (Animal a : animals) {
                boolean hasGoal;
                List<WrappedGoal> goals = a.goalSelector.getAvailableGoals().stream().filter(goal -> goal.isRunning() && goal.getGoal() instanceof GoToPositionGoal).toList();
                boolean bl = hasGoal = !goals.isEmpty();
                if (!hasGoal && a.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) >= 144.0 && world.random.nextInt(40) == 0) {
                    BlockPos target = pos.below().offset(world.random.nextInt(9) - 4, 0, world.random.nextInt(9) - 4);
                    a.goalSelector.addGoal(1, (Goal)new GoToPositionGoal((PathfinderMob)a, target, 1.0));
                    continue;
                }
                if (!hasGoal || !(a.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) < 64.0)) continue;
                for (Goal goal2 : goals) {
                    a.goalSelector.removeGoal(goal2);
                }
            }
        }
        return Ritual.RitualResult.PASS;
    }
}

