/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.tile;

import alexthw.eidolon_repraised.api.ritual.IRitualItemProvider;
import alexthw.eidolon_repraised.common.tile.ContainerTileBase;
import alexthw.eidolon_repraised.registries.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class HandTileEntity
extends ContainerTileBase
implements IRitualItemProvider {
    public HandTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)Registry.HAND_TILE_ENTITY.get(), pos, state);
    }

    public HandTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        if (!this.stack.isEmpty()) {
            Containers.dropItemStack((Level)this.level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)this.stack);
        }
    }

    @Override
    public ItemInteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.level != null && !this.level.isClientSide) {
            ItemStack itemInHand = player.getItemInHand(hand);
            if (itemInHand.isEmpty() && !this.stack.isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack);
                this.stack = ItemStack.EMPTY;
                if (!this.level.isClientSide) {
                    this.sync();
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (!itemInHand.isEmpty() && this.stack.isEmpty()) {
                this.stack = itemInHand.split(1);
                if (!this.level.isClientSide) {
                    this.sync();
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (!itemInHand.isEmpty()) {
                ItemStack oldstack = this.stack.copy();
                this.stack = itemInHand.split(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)oldstack);
                if (!this.level.isClientSide) {
                    this.sync();
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public ItemStack provide() {
        return this.stack.copy();
    }

    @Override
    public void take() {
        this.stack = ItemStack.EMPTY;
        if (!this.level.isClientSide) {
            this.sync();
        }
    }

    @Override
    public int getContainerSize() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    @NotNull
    public ItemStack getItem(int pSlot) {
        return this.stack;
    }

    @Override
    @NotNull
    public ItemStack removeItem(int pSlot, int pAmount) {
        ItemStack copyStack = this.stack.copy().split(pAmount);
        this.stack.shrink(pAmount);
        this.sync();
        return copyStack;
    }

    @Override
    @NotNull
    public ItemStack removeItemNoUpdate(int pSlot) {
        ItemStack stack = this.stack.copy();
        this.stack = ItemStack.EMPTY;
        this.sync();
        return stack;
    }

    @Override
    public void setItem(int pSlot, @NotNull ItemStack pStack) {
        this.stack = pStack;
        this.sync();
    }

    @Override
    public boolean canPlaceItem(int pIndex, @NotNull ItemStack pStack) {
        return this.stack.isEmpty();
    }

    @Override
    public boolean stillValid(@NotNull Player pPlayer) {
        return false;
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public void clearContent() {
        this.stack = ItemStack.EMPTY;
        this.sync();
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public void setStack(ItemStack otherStack) {
        this.stack = otherStack;
        this.sync();
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)compound.getCompound("itemStack"));
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (!this.stack.isEmpty()) {
            try {
                Tag stackTag = this.stack.save(pRegistries);
                tag.put("itemStack", stackTag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

