/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item.curio;

import alexthw.eidolon_repraised.common.item.ItemBase;
import alexthw.eidolon_repraised.registries.Registry;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class MindShieldingPlateItem
extends ItemBase {
    static final int LEVEL_FLAG = 0x40000000;

    public MindShieldingPlateItem(Item.Properties properties) {
        super(properties);
        NeoForge.EVENT_BUS.addListener(MindShieldingPlateItem::onPotion);
        NeoForge.EVENT_BUS.addListener(MindShieldingPlateItem::onClone);
        NeoForge.EVENT_BUS.addListener(MindShieldingPlateItem::onDropXP);
    }

    @SubscribeEvent
    public static void onPotion(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().getEffect() == MobEffects.CONFUSION && CuriosApi.getCuriosInventory((LivingEntity)event.getEntity()).flatMap(i -> i.findFirstCurio((Item)Registry.MIND_SHIELDING_PLATE.get())).isPresent()) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if ((event.getOriginal().experienceLevel & 0x40000000) != 0) {
            event.getEntity().experienceLevel = event.getOriginal().experienceLevel & 0xBFFFFFFF;
            event.getEntity().experienceProgress = event.getOriginal().experienceProgress;
        }
    }

    @SubscribeEvent
    public static void onDropXP(LivingExperienceDropEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (CuriosApi.getCuriosInventory((LivingEntity)event.getEntity()).flatMap(i -> i.findFirstCurio((Item)Registry.MIND_SHIELDING_PLATE.get())).isPresent()) {
                player.experienceLevel |= 0x40000000;
                event.setCanceled(true);
            }
        }
    }
}

