/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.api.capability;

import alexthw.eidolon_repraised.common.item.IWingsItem;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public interface IPlayerData {
    default public ItemStack getWingsItem(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(stacks -> stacks.findFirstCurio(s -> s.getItem() instanceof IWingsItem)).orElseGet(() -> new SlotResult(null, ItemStack.EMPTY)).stack();
    }

    default public int getMaxWingCharges(Player player) {
        ItemStack wings = this.getWingsItem(player);
        Item item = wings.getItem();
        if (item instanceof IWingsItem) {
            IWingsItem i = (IWingsItem)item;
            return i.getMaxCharges(wings);
        }
        return 0;
    }

    default public boolean isDashing(Player player) {
        return this.getDashTicks(player) > 0;
    }

    default public boolean canFlap(Player player) {
        return !player.onGround() && !player.isInPowderSnow && !player.isSwimming() && !player.isPassenger() && !player.getAbilities().flying;
    }

    public int getDashTicks(Player var1);

    public void doDashTick(Player var1);

    public boolean tryDash(Player var1);

    public int getWingCharges(Player var1);

    public void rechargeWings(Player var1);

    public boolean tryFlapWings(Player var1);

    public long getFlightStartTime(Player var1);

    public long getLastFlapTime(Player var1);

    public boolean isFlying(Player var1);

    public void startFlying(Player var1);

    public void stopFlying(Player var1);

    public void setDashTicks(int var1);

    public void setLastFlapTime(long var1);
}

