/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.block;

import alexthw.eidolon_repraised.common.block.BlockBase;
import alexthw.eidolon_repraised.registries.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class PillarBlockBase
extends BlockBase
implements SimpleWaterloggedBlock {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public PillarBlockBase(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean canConnectTo(LevelAccessor world, BlockPos pos, Direction dir) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof PillarBlockBase && dir.getAxis() == Direction.Axis.Y) {
            return true;
        }
        return dir == Direction.UP && state.getBlock() == Registry.STONE_HAND.get();
    }

    protected BlockState getState(Level world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)world, pos.above(), Direction.UP)))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)world, pos.below(), Direction.DOWN)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getState(context.getLevel(), context.getClickedPos());
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (facing == Direction.UP) {
            state = (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.above(), Direction.UP)));
        }
        if (facing == Direction.DOWN) {
            state = (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.below(), Direction.DOWN)));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TOP, BOTTOM, WATERLOGGED});
    }
}

