/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.codex;

import alexthw.eidolon_repraised.codex.CodexGui;
import alexthw.eidolon_repraised.codex.Page;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class TitlePage
extends Page {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/codex_title_page.png");
    final String text;
    final String title;
    ItemStack reference = ItemStack.EMPTY;

    public TitlePage(String textKey) {
        super(BACKGROUND);
        this.text = textKey;
        this.title = textKey + ".title";
    }

    public TitlePage(String textKey, String titleKey) {
        super(BACKGROUND);
        this.text = textKey;
        this.title = titleKey;
    }

    public TitlePage(String textKey, ItemStack reference) {
        super(BACKGROUND);
        this.text = textKey;
        this.title = reference.getDescriptionId();
        this.reference = reference;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics mStack, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        String title = I18n.get((String)this.title, (Object[])new Object[0]);
        int titleWidth = Minecraft.getInstance().font.width(title);
        int n = x + 64 - titleWidth / 2;
        Objects.requireNonNull(Minecraft.getInstance().font);
        TitlePage.drawText(mStack, title, n, y + 15 - 9);
        TitlePage.drawWrappingText(mStack, I18n.get((String)this.text, (Object[])new Object[0]), x + 4, y + 24, 120);
    }
}

