/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.common.tile.CrucibleTileEntity;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrucibleRecipe
implements Recipe<CraftingInput> {
    List<Step> steps;
    ResourceLocation registryName;
    final ItemStack result;

    public ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        for (Step step : this.steps) {
            ingredients.addAll(step.matches);
        }
        return ingredients;
    }

    public CrucibleRecipe(List<Step> steps, ItemStack result) {
        this.steps = steps;
        this.result = result;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public CrucibleRecipe setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        return this;
    }

    public boolean matches(List<CrucibleTileEntity.CrucibleStep> items) {
        if (this.steps.size() != items.size()) {
            return false;
        }
        ArrayList<Ingredient> matchList = new ArrayList<Ingredient>();
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.steps.size(); ++i) {
            Step correct = this.steps.get(i);
            CrucibleTileEntity.CrucibleStep provided = items.get(i);
            if (correct.stirs != provided.getStirs()) {
                return false;
            }
            matchList.clear();
            itemList.clear();
            matchList.addAll(correct.matches);
            itemList.addAll(provided.getContents());
            block1: for (int j = 0; j < matchList.size(); ++j) {
                for (int k = 0; k < itemList.size(); ++k) {
                    if (!((Ingredient)matchList.get(j)).test((ItemStack)itemList.get(k))) continue;
                    matchList.remove(j--);
                    itemList.remove(k--);
                    continue block1;
                }
            }
            if (matchList.isEmpty() && itemList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level worldIn) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registryAccess) {
        return this.getResultItem();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registryAccess) {
        return this.result;
    }

    @NotNull
    public ItemStack getResultItem() {
        return this.result;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.registryName;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.CRUCIBLE_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.CRUCIBLE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public record Step(int stirs, List<Ingredient> matches) {
        public static final Codec<Step> STEP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("stirs", (Object)0).forGetter(s -> s.stirs), (App)Ingredient.CODEC.listOf().optionalFieldOf("items", new ArrayList()).forGetter(s -> s.matches)).apply((Applicative)instance, Step::new));
        public static StreamCodec<RegistryFriendlyByteBuf, Step> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Step::stirs, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), Step::matches, Step::new);

        public Step(int stirs, List<Ingredient> matches) {
            this.stirs = stirs;
            this.matches = new ArrayList<Ingredient>(matches);
        }
    }

    public static class Serializer
    implements RecipeSerializer<CrucibleRecipe> {
        public static final MapCodec<CrucibleRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Step.STEP_CODEC.listOf().fieldOf("steps").forGetter(r -> r.steps), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result)).apply((Applicative)instance, CrucibleRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CrucibleRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Step.STREAM_CODEC.apply(ByteBufCodecs.list()), CrucibleRecipe::getSteps, (StreamCodec)ItemStack.STREAM_CODEC, CrucibleRecipe::getResultItem, CrucibleRecipe::new);

        @NotNull
        public MapCodec<CrucibleRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CrucibleRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

