/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.api.capability.IMana;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.common.spell.StaticSpell;
import alexthw.eidolon_repraised.registries.EidolonPotions;
import alexthw.eidolon_repraised.registries.Researches;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class FrostSpell
extends StaticSpell {
    public FrostSpell(ResourceLocation name, Sign ... signs) {
        super(name, 20, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        BlockHitResult rayTraceResult;
        FluidState fluidState;
        if (!KnowledgeUtil.knowsResearch(player, Researches.FROST_SPELL.getRegistryName())) {
            return false;
        }
        HitResult ray = FrostSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
        if (ray instanceof BlockHitResult && (fluidState = world.getFluidState((rayTraceResult = (BlockHitResult)ray).getBlockPos())).is((Fluid)Fluids.WATER) && fluidState.isSource()) {
            return true;
        }
        return ray instanceof EntityHitResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        if (world.isClientSide) return;
        HitResult ray = FrostSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
        if (ray instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)ray;
            FluidState fluidState = world.getFluidState(blockHitResult.getBlockPos());
            if (!fluidState.is((Fluid)Fluids.WATER) || !fluidState.isSource()) return;
            world.setBlockAndUpdate(blockHitResult.getBlockPos(), Blocks.ICE.defaultBlockState());
            world.playSound(player, pos, SoundEvents.PLAYER_HURT_FREEZE, SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
        } else {
            EntityHitResult entityHitResult;
            Entity entity;
            if (!(ray instanceof EntityHitResult) || !((entity = (entityHitResult = (EntityHitResult)ray).getEntity()) instanceof LivingEntity)) return;
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(EidolonPotions.CHILLED_EFFECT, 200));
        }
        IMana.expendMana(player, this.getCost());
    }
}

