/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item;

import alexthw.eidolon_repraised.registries.Registry;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class Tiers {

    public static class NecroticTier
    implements Tier {
        public static final MagicToolTier INSTANCE = new MagicToolTier();

        public int getUses() {
            return 2161;
        }

        public float getSpeed() {
            return 8.0f;
        }

        public float getAttackDamageBonus() {
            return 3.0f;
        }

        @NotNull
        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 30;
        }

        @NotNull
        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registry.DEATH_ESSENCE.get()});
        }
    }

    public static class SanguineTier
    implements Tier {
        public static final SanguineTier INSTANCE = new SanguineTier();

        public int getUses() {
            return 507;
        }

        public float getSpeed() {
            return 8.0f;
        }

        public float getAttackDamageBonus() {
            return 3.0f;
        }

        @NotNull
        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
        }

        public int getEnchantmentValue() {
            return 20;
        }

        @NotNull
        public Ingredient getRepairIngredient() {
            return Ingredient.EMPTY;
        }
    }

    public static class SilverTier
    implements Tier {
        public static final SilverTier INSTANCE = new SilverTier();

        public int getUses() {
            return 193;
        }

        public float getSpeed() {
            return 7.0f;
        }

        public float getAttackDamageBonus() {
            return 2.0f;
        }

        @NotNull
        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 20;
        }

        @NotNull
        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Registry.SILVER_INGOT.get())});
        }
    }

    public static class MagicToolTier
    implements Tier {
        public static final MagicToolTier INSTANCE = new MagicToolTier();

        public int getUses() {
            return 1170;
        }

        public float getSpeed() {
            return 7.0f;
        }

        public float getAttackDamageBonus() {
            return 3.0f;
        }

        @NotNull
        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
        }

        public int getEnchantmentValue() {
            return 30;
        }

        @NotNull
        public Ingredient getRepairIngredient() {
            return Ingredient.EMPTY;
        }
    }

    public static class PewterTier
    implements Tier {
        public static final PewterTier INSTANCE = new PewterTier();

        public int getUses() {
            return 325;
        }

        public float getSpeed() {
            return 6.5f;
        }

        public float getAttackDamageBonus() {
            return 2.0f;
        }

        @NotNull
        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 8;
        }

        @NotNull
        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Registry.PEWTER_INGOT.get())});
        }
    }
}

