/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item;

import alexthw.eidolon_repraised.common.item.Tiers;
import alexthw.eidolon_repraised.network.LifestealEffectPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.util.DamageTypeData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class SappingSwordItem
extends SwordItem {
    String loreTag = null;

    public SappingSwordItem(Item.Properties builderIn) {
        super((Tier)Tiers.SanguineTier.INSTANCE, builderIn.attributes(SappingSwordItem.createAttributes((Tier)Tiers.SanguineTier.INSTANCE, (int)1, (float)-2.4f)));
    }

    public Item setLore(String tag) {
        this.loreTag = tag;
        return this;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        if (this.loreTag != null) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_PURPLE) + String.valueOf(ChatFormatting.ITALIC) + I18n.get((String)this.loreTag, (Object[])new Object[0]))));
        }
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, LivingEntity target, @NotNull LivingEntity attacker) {
        if (target.invulnerableTime > 0) {
            target.invulnerableTime = 0;
            float before = target.getHealth();
            target.hurt(DamageTypeData.source((LevelAccessor)target.level(), (ResourceKey<DamageType>)DamageTypes.WITHER, (Entity)attacker, null), 2.0f);
            float healing = before - target.getHealth();
            if (healing > 0.0f) {
                attacker.heal(healing);
                if (!attacker.level().isClientSide) {
                    Networking.sendToNearbyClient(attacker.level(), attacker.blockPosition(), (CustomPacketPayload)new LifestealEffectPacket(target.blockPosition(), attacker.blockPosition(), 1.0f, 0.125f, 0.1875f));
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }
}

