/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.registries;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.capability.KnowledgeImpl;
import alexthw.eidolon_repraised.capability.PatronManaImpl;
import alexthw.eidolon_repraised.capability.ReputationImpl;
import alexthw.eidolon_repraised.capability.SoulImpl;
import alexthw.eidolon_repraised.capability.WingsDataImpl;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="eidolon_repraised")
public class EidolonCapabilities {
    public static final EntityCapability<PatronManaImpl, @Nullable Void> MANA_CAPABILITY = EntityCapability.createVoid((ResourceLocation)Eidolon.prefix("mana"), PatronManaImpl.class);
    public static final EntityCapability<SoulImpl, @Nullable Void> SOUL_HEART_CAPABILITY = EntityCapability.createVoid((ResourceLocation)Eidolon.prefix("soul"), SoulImpl.class);
    public static final EntityCapability<KnowledgeImpl, @Nullable Void> KNOWLEDGE_CAPABILITY = EntityCapability.createVoid((ResourceLocation)Eidolon.prefix("knowledge"), KnowledgeImpl.class);
    public static final EntityCapability<ReputationImpl, @Nullable Void> REPUTATION_CAPABILITY = EntityCapability.createVoid((ResourceLocation)Eidolon.prefix("reputation"), ReputationImpl.class);
    public static final EntityCapability<WingsDataImpl, @Nullable Void> WINGS_CAPABILITY = EntityCapability.createVoid((ResourceLocation)Eidolon.prefix("player"), WingsDataImpl.class);

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(MANA_CAPABILITY, EntityType.PLAYER, (player, ctx) -> new PatronManaImpl((LivingEntity)player));
        event.registerEntity(SOUL_HEART_CAPABILITY, EntityType.PLAYER, (player, ctx) -> new SoulImpl((LivingEntity)player));
        event.registerEntity(KNOWLEDGE_CAPABILITY, EntityType.PLAYER, (player, ctx) -> new KnowledgeImpl((LivingEntity)player));
        event.registerEntity(REPUTATION_CAPABILITY, EntityType.PLAYER, (player, ctx) -> new ReputationImpl((Player)player));
        event.registerEntity(WINGS_CAPABILITY, EntityType.PLAYER, (player, ctx) -> new WingsDataImpl((LivingEntity)player));
        List<BlockEntityType> invWrappers = List.of((BlockEntityType)Registry.HAND_TILE_ENTITY.get(), (BlockEntityType)Registry.CENSER_TILE_ENTITY.get(), (BlockEntityType)Registry.NECROTIC_FOCUS_TILE_ENTITY.get(), (BlockEntityType)Registry.BRAZIER_TILE_ENTITY.get());
        for (BlockEntityType tileEntity : invWrappers) {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, tileEntity, (blockEntity, ctx) -> new InvWrapper((Container)blockEntity));
        }
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)Registry.CRUCIBLE_TILE_ENTITY.get(), (blockEntity, ctx) -> blockEntity.tank);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Registry.CRUCIBLE_TILE_ENTITY.get(), (blockEntity, ctx) -> new InvWrapper((Container)blockEntity));
    }
}

