/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.network;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.client.particle.Particles;
import alexthw.eidolon_repraised.client.particle.SlashParticleData;
import alexthw.eidolon_repraised.network.AbstractPacket;
import alexthw.eidolon_repraised.registries.EidolonParticles;
import alexthw.eidolon_repraised.util.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DeathbringerSlashEffectPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<DeathbringerSlashEffectPacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("deathbringer_slash_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DeathbringerSlashEffectPacket> CODEC = StreamCodec.ofMember(DeathbringerSlashEffectPacket::encode, DeathbringerSlashEffectPacket::decode);
    final float x1;
    final float y1;
    final float z1;
    final float x2;
    final float y2;
    final float z2;
    final int c1;
    final int c2;
    final int c3;
    final int c4;

    public DeathbringerSlashEffectPacket(float x1, float y1, float z1, float x2, float y2, float z2, int color1, int color2, int color3, int color4) {
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.c1 = color1;
        this.c2 = color2;
        this.c3 = color3;
        this.c4 = color4;
    }

    public static void encode(DeathbringerSlashEffectPacket object, FriendlyByteBuf buffer) {
        buffer.writeFloat(object.x1).writeFloat(object.y1).writeFloat(object.z1);
        buffer.writeFloat(object.x2).writeFloat(object.y2).writeFloat(object.z2);
        buffer.writeInt(object.c1).writeInt(object.c2).writeInt(object.c3).writeInt(object.c4);
    }

    public static DeathbringerSlashEffectPacket decode(FriendlyByteBuf buffer) {
        return new DeathbringerSlashEffectPacket(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Level world = player.level();
        double x = this.x2;
        double y = this.y2;
        double z = this.z2;
        float r1 = (float)ColorUtil.getRed(this.c1) / 255.0f;
        float g1 = (float)ColorUtil.getGreen(this.c1) / 255.0f;
        float b1 = (float)ColorUtil.getBlue(this.c1) / 255.0f;
        float r2 = (float)ColorUtil.getRed(this.c2) / 255.0f;
        float g2 = (float)ColorUtil.getGreen(this.c2) / 255.0f;
        float b2 = (float)ColorUtil.getBlue(this.c2) / 255.0f;
        float roll = 0.5235988f - world.random.nextFloat() * 3.6651917f;
        float scale = 1.0f + world.random.nextFloat() * 0.2f;
        Vec3 horiz = new Vec3(x - (double)this.x1, 0.0, z - (double)this.z1);
        float yaw = (float)Mth.atan2((double)(x - (double)this.x1), (double)(z - (double)this.z1));
        float pitch = (float)Mth.atan2((double)(y - (double)this.y1), (double)horiz.length());
        float right = yaw + 1.5707964f;
        float up = pitch + 1.5707964f;
        float sy = Mth.sin((float)yaw);
        float cy = Mth.cos((float)yaw);
        float sp = Mth.sin((float)pitch);
        float cp = Mth.cos((float)pitch);
        float sr = Mth.sin((float)right);
        float cr = Mth.cos((float)right);
        float su = Mth.sin((float)up);
        float cu = Mth.cos((float)up);
        float r = 0.5f;
        float xax = r * sr * cp;
        float xay = 0.0f;
        float xaz = r * cr * cp;
        float yax = r * sy * cu;
        float yay = r * su;
        float yaz = r * cy * cu;
        float zax = r * sy * cp;
        float zay = r * sp;
        float zaz = r * cy * cp;
        float cro = Mth.cos((float)roll);
        float sro = Mth.sin((float)roll);
        float nxax = xax * cro - yax * sro;
        float nxay = xay * cro - yay * sro;
        float nxaz = xaz * cro - yaz * sro;
        yax = xax * sro + yax * cro;
        yay = xay * sro + yay * cro;
        yaz = xaz * sro + yaz * cro;
        xax = nxax;
        xay = nxay;
        xaz = nxaz;
        for (float i = 0.0f; i < 6.0f; i += 1.0f) {
            float c1 = (i + 0.5f) / 6.0f;
            float angle = -75.0f + c1 * 150.0f;
            float sa = Mth.sin((float)((float)Math.PI / 180 * angle));
            float ca = Mth.cos((float)((float)Math.PI / 180 * angle));
            float dx = sa * xax + ca * zax;
            float dy = sa * xay + ca * zay;
            float dz = sa * xaz + ca * zaz;
            Particles.create((ParticleType)EidolonParticles.SMOKE_PARTICLE.get()).randomVelocity(0.025f).addVelocity(dx * 0.25f, dy * 0.25f, dz * 0.25f).setColor(0.12941177f, 0.101960786f, 0.09019608f, 0.125f, 0.039215688f, 0.039215688f, 0.047058824f, 0.0f).randomOffset(0.1f).setScale(0.375f, 0.125f).repeat(world, x - (double)(sy * cp) + (double)dx, y - (double)sp + (double)dy, z - (double)(cy * cp) + (double)dz, 4);
        }
        SlashParticleData.create((ParticleType)EidolonParticles.GLOWING_SLASH_PARTICLE.get()).lookat(this.x1, this.y1, this.z1, x, y, z).color(r1, g1, b1, r2, g2, b2).radius(0.9f * scale).angle(250.0f).width(scale).roll(roll).lifetime(11).spawn(world, x, y, z, 0.0, 0.0, 0.0);
        SlashParticleData.create((ParticleType)EidolonParticles.GLOWING_SLASH_PARTICLE.get()).lookat(this.x1, this.y1, this.z1, x, y, z).color(r1, g1, b1, r2, g2, b2).radius(0.8f * scale).angle(250.0f).width(0.75f * scale).roll(roll).lifetime(11).spawn(world, x, y, z, 0.0, 0.0, 0.0);
        SlashParticleData.create((ParticleType)EidolonParticles.GLOWING_SLASH_PARTICLE.get()).lookat(this.x1, this.y1, this.z1, x, y, z).color(r1, g1, b1, r2, g2, b2).radius(0.7f * scale).angle(250.0f).width(0.5f * scale).roll(roll).lifetime(13).spawn(world, x, y, z, 0.0, 0.0, 0.0);
        r1 = (float)ColorUtil.getRed(this.c3) / 255.0f;
        g1 = (float)ColorUtil.getGreen(this.c3) / 255.0f;
        b1 = (float)ColorUtil.getBlue(this.c3) / 255.0f;
        r2 = (float)ColorUtil.getRed(this.c4) / 255.0f;
        g2 = (float)ColorUtil.getGreen(this.c4) / 255.0f;
        b2 = (float)ColorUtil.getBlue(this.c4) / 255.0f;
        SlashParticleData.create((ParticleType)EidolonParticles.GLOWING_SLASH_PARTICLE.get()).lookat(this.x1, this.y1, this.z1, x, y, z).color(r1, g1, b1, r2, g2, b2).radius(0.8f * scale).angle(210.0f).width(0.625f * scale).highlight(0.75f).alpha(0.75f, 0.0f).roll(roll).lifetime(8).spawn(world, x, y, z, 0.0, 0.0, 0.0);
        SlashParticleData.create((ParticleType)EidolonParticles.GLOWING_SLASH_PARTICLE.get()).lookat(this.x1, this.y1, this.z1, x, y, z).color(r1, g1, b1, r2, g2, b2).radius(0.9f * scale).angle(210.0f).width(0.25f * scale).highlight(0.625f).roll(roll).lifetime(10).spawn(world, x, y, z, 0.0, 0.0, 0.0);
    }

    @NotNull
    public CustomPacketPayload.Type<DeathbringerSlashEffectPacket> type() {
        return TYPE;
    }
}

