/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item.model;

import alexthw.eidolon_repraised.capability.WingsDataImpl;
import alexthw.eidolon_repraised.common.item.IWingsItem;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RavenCloakModel
extends HumanoidModel<LivingEntity> {
    final ModelPart root;
    final ModelPart cloak;
    final ModelPart wings;
    final ModelPart leftWing;
    final ModelPart rightWing;

    public RavenCloakModel(ModelPart root) {
        super(root);
        this.root = root;
        this.cloak = root.getChild("body").getChild("cloak");
        this.wings = root.getChild("body").getChild("wings");
        this.leftWing = this.wings.getChild("left_wing");
        this.rightWing = this.wings.getChild("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.0f), (float)0.0f);
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition head = root.addOrReplaceChild("head", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition hood = head.addOrReplaceChild("hood", CubeListBuilder.create().texOffs(0, 0).addBox(-5.5f, -10.5f, -4.5f, 11.0f, 11.0f, 11.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_feather1 = hood.addOrReplaceChild("left_feather1", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)-3.0f, (float)-2.0f, (float)2.0944f, (float)0.0f, (float)0.5236f));
        PartDefinition left_feather2 = hood.addOrReplaceChild("left_feather2", CubeListBuilder.create().texOffs(0, 17).mirror().addBox(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)-3.0f, (float)1.0f, (float)1.5708f, (float)0.0f, (float)0.7854f));
        PartDefinition left_feather3 = hood.addOrReplaceChild("left_feather3", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)-2.0f, (float)4.0f, (float)1.0472f, (float)0.0f, (float)0.5236f));
        PartDefinition right_feather1 = hood.addOrReplaceChild("right_feather1", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-3.0f, (float)-2.0f, (float)2.0944f, (float)0.0f, (float)-0.5236f));
        PartDefinition right_feather2 = hood.addOrReplaceChild("right_feather2", CubeListBuilder.create().texOffs(0, 17).addBox(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-3.0f, (float)1.0f, (float)1.5708f, (float)0.0f, (float)-0.7854f));
        PartDefinition right_feather3 = hood.addOrReplaceChild("right_feather3", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-2.0f, (float)4.0f, (float)1.0472f, (float)0.0f, (float)-0.5236f));
        PartDefinition beak = hood.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(33, 0).addBox(-2.5f, 0.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)-5.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cloak = body.addOrReplaceChild("cloak", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition left_cloak = cloak.addOrReplaceChild("left_cloak", CubeListBuilder.create().texOffs(0, 28).mirror().addBox(-0.5f, -4.0f, -4.0f, 12.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.5f, (float)1.0f, (float)-3.0f, (float)0.1309f, (float)-0.1309f, (float)-0.1309f));
        PartDefinition right_cloak = cloak.addOrReplaceChild("right_cloak", CubeListBuilder.create().texOffs(0, 28).addBox(-11.5f, -4.0f, -4.0f, 12.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)1.0f, (float)-3.0f, (float)0.1309f, (float)0.1309f, (float)0.1309f));
        PartDefinition wings = body.addOrReplaceChild("wings", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition upper_left_cloak = wings.addOrReplaceChild("upper_left_cloak", CubeListBuilder.create().texOffs(0, 28).mirror().addBox(0.5f, -4.0f, -4.0f, 12.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.5f, (float)4.0f, (float)-3.0f, (float)0.1309f, (float)-0.1309f, (float)-0.5236f));
        PartDefinition upper_right_cloak = wings.addOrReplaceChild("upper_right_cloak", CubeListBuilder.create().texOffs(0, 28).addBox(-12.5f, -4.0f, -4.0f, 12.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)4.0f, (float)-3.0f, (float)0.1309f, (float)0.1309f, (float)0.5236f));
        PartDefinition left_wing = wings.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(51, 0).addBox(0.0f, 0.0f, -2.0f, 12.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 41).addBox(-4.0f, 8.0f, -1.0f, 14.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)5.0f, (float)0.0f, (float)-0.5236f, (float)-0.3927f));
        PartDefinition left_wing_mid = left_wing.addOrReplaceChild("left_wing_mid", CubeListBuilder.create().texOffs(72, 10).addBox(0.0f, 0.0f, -1.0f, 12.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 27).addBox(-1.0f, 8.0f, -0.5f, 14.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)12.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.2618f, (float)0.1309f));
        PartDefinition left_wing_tip = left_wing_mid.addOrReplaceChild("left_wing_tip", CubeListBuilder.create().texOffs(44, 11).addBox(0.0f, 0.0f, -1.0f, 14.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.5f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.5236f, (float)-0.1309f));
        PartDefinition right_wing = wings.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(51, 0).mirror().addBox(-12.0f, 0.0f, -2.0f, 12.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(48, 41).mirror().addBox(-10.0f, 8.0f, -1.0f, 14.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)5.0f, (float)0.0f, (float)0.5236f, (float)0.3927f));
        PartDefinition right_wing_mid = right_wing.addOrReplaceChild("right_wing_mid", CubeListBuilder.create().texOffs(72, 10).mirror().addBox(-12.0f, 0.0f, -1.0f, 12.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(44, 27).mirror().addBox(-13.0f, 8.0f, -0.5f, 14.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-12.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)-0.2618f, (float)-0.1309f));
        PartDefinition right_wing_tip = right_wing_mid.addOrReplaceChild("right_wing_tip", CubeListBuilder.create().texOffs(44, 11).mirror().addBox(-14.0f, 0.0f, -1.0f, 14.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-11.5f, (float)0.0f, (float)0.5f, (float)0.0f, (float)-0.5236f, (float)0.1309f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void setupAnim(@NotNull LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            float pticks = Minecraft.getInstance().getFrameTimeNs();
            WingsDataImpl data = (WingsDataImpl)p.getCapability(EidolonCapabilities.WINGS_CAPABILITY);
            float timeSinceFlying = Mth.clamp((float)((float)(p.level().getGameTime() - data.getFlightStartTime(p)) + pticks), (float)0.0f, (float)10.0f);
            float timeSinceFlapping = Mth.clamp((float)((float)(p.level().getGameTime() - data.getLastFlapTime(p)) + pticks), (float)0.01f, (float)20.0f);
            ModelPart leftMid = this.leftWing.getChild("left_wing_mid");
            ModelPart leftTip = leftMid.getChild("left_wing_tip");
            ModelPart rightMid = this.rightWing.getChild("right_wing_mid");
            ModelPart rightTip = rightMid.getChild("right_wing_tip");
            float unfurl = 0.0f;
            timeSinceFlapping /= 20.0f;
            float flap1 = Mth.sin((float)(7.539823f * (timeSinceFlapping -= 0.16666667f))) / (7.539823f * timeSinceFlapping);
            float flap2 = -Mth.sin((float)((float)Math.PI * 2 * Mth.sqrt((float)(timeSinceFlapping += 0.16666667f))));
            flap2 *= 1.5f - 0.5f * timeSinceFlapping;
            if (data.isFlying(p)) {
                this.cloak.visible = false;
                this.wings.visible = true;
                unfurl = (10.0f - timeSinceFlying) / 10.0f;
                unfurl *= unfurl;
                unfurl = 1.0f - unfurl;
            } else {
                this.cloak.visible = timeSinceFlying >= 10.0f;
                this.wings.visible = timeSinceFlying < 10.0f;
                unfurl = (10.0f - timeSinceFlying) / 10.0f;
                unfurl *= unfurl;
            }
            float leftWingX = 0.7854f;
            float leftWingY = -0.5236f;
            float leftWingZ = -0.7854f;
            float rightWingX = 0.7854f;
            float rightWingY = 0.5236f;
            float rightWingZ = 0.7854f;
            float leftMidX = 0.0f;
            float leftMidY = 0.2618f;
            float leftTipY = 0.5236f;
            float rightMidX = 0.0f;
            float rightMidY = -0.2618f;
            float rightTipY = -0.5236f;
            if (data.isDashing(p)) {
                int n;
                ItemStack wings = data.getWingsItem(p);
                Item item = wings.getItem();
                if (item instanceof IWingsItem) {
                    IWingsItem i = (IWingsItem)item;
                    n = i.getDashTicks(wings);
                } else {
                    n = 0;
                }
                int maxDash = n;
                int dashTicks = data.getDashTicks(p);
                int sinceDashing = maxDash - dashTicks;
                float dashStart = Mth.clamp((float)((float)sinceDashing / 10.0f), (float)0.01f, (float)1.0f);
                leftWingZ = Mth.lerp((float)dashStart, (float)leftWingZ, (float)0.0f);
                rightWingZ = Mth.lerp((float)dashStart, (float)rightWingZ, (float)0.0f);
                leftWingY = Mth.lerp((float)dashStart, (float)leftWingZ, (float)0.0f);
                rightWingY = Mth.lerp((float)dashStart, (float)rightWingZ, (float)0.0f);
                leftWingX = Mth.lerp((float)dashStart, (float)leftWingX, (float)0.2618f);
                rightWingX = Mth.lerp((float)dashStart, (float)rightWingX, (float)0.2618f);
            }
            leftWingX = Mth.lerp((float)flap1, (float)leftWingX, (float)1.5708f);
            leftWingY = Mth.lerp((float)flap1, (float)leftWingY, (float)1.047f);
            leftWingZ = Mth.lerp((float)flap1, (float)leftWingZ, (float)0.5236f);
            leftMidY = Mth.lerp((float)flap2, (float)leftMidY, (float)0.7854f);
            rightWingX = Mth.lerp((float)flap1, (float)rightWingX, (float)1.5708f);
            rightWingY = Mth.lerp((float)flap1, (float)rightWingY, (float)-1.047f);
            rightWingZ = Mth.lerp((float)flap1, (float)rightWingZ, (float)-0.5236f);
            rightMidY = Mth.lerp((float)flap2, (float)rightMidY, (float)-0.7854f);
            leftWingX = Mth.lerp((float)unfurl, (float)0.0f, (float)leftWingX);
            leftWingY = Mth.lerp((float)unfurl, (float)0.2618f, (float)leftWingY);
            leftWingZ = Mth.lerp((float)unfurl, (float)-0.3927f, (float)leftWingZ);
            leftMidY = Mth.lerp((float)unfurl, (float)1.4399f, (float)leftMidY);
            leftTipY = Mth.lerp((float)unfurl, (float)1.5708f, (float)leftTipY);
            rightWingX = Mth.lerp((float)unfurl, (float)0.0f, (float)rightWingX);
            rightWingY = Mth.lerp((float)unfurl, (float)-0.2618f, (float)rightWingY);
            rightWingZ = Mth.lerp((float)unfurl, (float)0.3927f, (float)rightWingZ);
            rightMidY = Mth.lerp((float)unfurl, (float)-1.4399f, (float)rightMidY);
            rightTipY = Mth.lerp((float)unfurl, (float)-1.5708f, (float)rightTipY);
            if (p.isCrouching()) {
                leftWingY += 0.3927f;
                rightWingY -= 0.3927f;
                leftWingZ += 0.3927f;
                rightWingZ -= 0.3927f;
            }
            float clampedDY = (float)Mth.clamp((double)p.getDeltaMovement().y, (double)-0.5, (double)0.5);
            rightWingZ -= clampedDY * 0.5236f;
            this.leftWing.xRot = leftWingX;
            this.leftWing.yRot = leftWingY;
            this.leftWing.zRot = leftWingZ += clampedDY * 0.5236f;
            leftMid.yRot = leftMidY;
            leftTip.yRot = leftTipY;
            this.rightWing.xRot = rightWingX;
            this.rightWing.yRot = rightWingY;
            this.rightWing.zRot = rightWingZ;
            rightMid.yRot = rightMidY;
            rightTip.yRot = rightTipY;
        }
    }

    @NotNull
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.root.getChild("head"));
    }

    @NotNull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.root.getChild("body"));
    }
}

