/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.util;

import alexthw.eidolon_repraised.Eidolon;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class DamageTypeData {
    private static final List<DamageTypeData> all = new ArrayList<DamageTypeData>();
    public final ResourceKey<DamageType> key;
    public final ResourceLocation id;
    public final DamageType type;
    public final Collection<TagKey<DamageType>> tags;
    private Holder<DamageType> holder;
    private final WorldAttached<DamageSource> staticSources;

    protected DamageTypeData(ResourceKey<DamageType> key, DamageType type, Collection<TagKey<DamageType>> tags) {
        this.key = key;
        this.id = key.location();
        this.type = type;
        this.tags = tags;
        this.staticSources = new WorldAttached<DamageSource>(level -> new DamageSource(this.getHolder((LevelAccessor)level)));
    }

    public DamageSource source(LevelAccessor level) {
        return this.staticSources.get(level);
    }

    public DamageSource source(LevelAccessor level, @Nullable Entity entity) {
        return new DamageSource(this.getHolder(level), entity);
    }

    public DamageSource source(LevelAccessor level, @Nullable Entity cause, @Nullable Entity direct) {
        return new DamageSource(this.getHolder(level), cause, direct);
    }

    private Holder<DamageType> getHolder(LevelAccessor level) {
        if (this.holder == null) {
            Registry registry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
            this.holder = registry.getHolderOrThrow(this.key);
        }
        return this.holder;
    }

    public static DamageSource source(LevelAccessor level, ResourceKey<DamageType> key) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        return new DamageSource((Holder)registry.getHolderOrThrow(key));
    }

    public static DamageSource source(LevelAccessor level, ResourceKey<DamageType> key, @Nullable Entity entity, @Nullable Entity direct) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        if (entity != null && direct != null) {
            return new DamageSource((Holder)registry.getHolderOrThrow(key), entity, direct);
        }
        if (entity != null) {
            return new DamageSource((Holder)registry.getHolderOrThrow(key), entity);
        }
        return new DamageSource((Holder)registry.getHolderOrThrow(key));
    }

    public boolean is(@Nullable DamageSource source) {
        return source != null && this.is(source.type());
    }

    public boolean is(DamageType type) {
        return this.type.equals((Object)type);
    }

    public void register(BootstrapContext<DamageType> ctx) {
        ctx.register(this.key, (Object)this.type);
    }

    public static Stream<DamageTypeData> allInNamespace(String namespace) {
        return all.stream().filter(data -> data.id.getNamespace().equals(namespace));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class WorldAttached<T> {
        static final List<WeakReference<Map<LevelAccessor, ?>>> allMaps = new ArrayList();
        private final Map<LevelAccessor, T> attached;
        private final Function<LevelAccessor, T> factory;

        public WorldAttached(Function<LevelAccessor, T> factory) {
            this.factory = factory;
            this.attached = new WeakHashMap<LevelAccessor, T>();
            allMaps.add(new WeakReference<Map<LevelAccessor, T>>(this.attached));
        }

        public static void invalidateWorld(LevelAccessor world) {
            Iterator<WeakReference<Map<LevelAccessor, ?>>> i = allMaps.iterator();
            while (i.hasNext()) {
                Map map = (Map)i.next().get();
                if (map == null) {
                    i.remove();
                    continue;
                }
                map.remove(world);
            }
        }

        @Nonnull
        public T get(LevelAccessor world) {
            T t = this.attached.get(world);
            if (t != null) {
                return t;
            }
            T entry = this.factory.apply(world);
            this.put(world, entry);
            return entry;
        }

        public void put(LevelAccessor world, T entry) {
            this.attached.put(world, entry);
        }

        @Nonnull
        public T replace(LevelAccessor world) {
            this.attached.remove(world);
            return this.get(world);
        }

        @Nonnull
        public T replace(LevelAccessor world, Consumer<T> finalizer) {
            T remove = this.attached.remove(world);
            if (remove != null) {
                finalizer.accept(remove);
            }
            return this.get(world);
        }

        public void empty(BiConsumer<LevelAccessor, T> finalizer) {
            this.attached.forEach(finalizer);
            this.attached.clear();
        }

        public void empty(Consumer<T> finalizer) {
            this.attached.values().forEach(finalizer);
            this.attached.clear();
        }
    }

    public static class Builder {
        private String msgId;
        private ResourceLocation location;
        private float exhaustion = 0.0f;
        private DamageScaling scaling = DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
        private DamageEffects effects = DamageEffects.HURT;
        private DeathMessageType deathMessageType = DeathMessageType.DEFAULT;
        private final List<TagKey<DamageType>> tags = new ArrayList<TagKey<DamageType>>();

        public Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public Builder location(String path) {
            return this.location(Eidolon.prefix(path));
        }

        public Builder simpleId(ResourceLocation location) {
            this.location(location);
            return this.msgId(location.getNamespace() + "." + location.getPath());
        }

        public Builder simpleId(String path) {
            return this.simpleId(Eidolon.prefix(path));
        }

        public Builder msgId(String msgId) {
            this.msgId = msgId;
            return this;
        }

        public Builder exhaustion(float exhaustion) {
            this.exhaustion = exhaustion;
            return this;
        }

        public Builder scaling(DamageScaling scaling) {
            this.scaling = scaling;
            return this;
        }

        public Builder effects(DamageEffects effects) {
            this.effects = effects;
            return this;
        }

        public Builder deathMessageType(DeathMessageType type) {
            this.deathMessageType = type;
            return this;
        }

        @SafeVarargs
        public final Builder tag(TagKey<DamageType> ... tags) {
            Collections.addAll(this.tags, tags);
            return this;
        }

        public DamageTypeData build() {
            if (this.location == null) {
                throw new IllegalArgumentException("location is required");
            }
            if (this.msgId == null) {
                throw new IllegalArgumentException("msgId is required");
            }
            DamageTypeData data = new DamageTypeData((ResourceKey<DamageType>)ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)this.location), new DamageType(this.msgId, this.scaling, this.exhaustion, this.effects, this.deathMessageType), this.tags);
            all.add(data);
            return data;
        }
    }
}

